

import json
import smtplib
import os

from app.engines.base_engine import BaseEngine
from app.db.db import new_session
from app.db.models import DebbyProject, DebbyPolicy, PipelineScans, DebbyScanResults
from app.db.models import DebbyTask, DebbyScan, DebbyTag, RelationProjectTag
from app.engines.utils import target_generator_helper
from app.settings import PROTO_TCP
from app.utils import addr_to_proto, datetime_msk_2_timestamp_utc, is_valid_ipv4_address, is_valid_ipv6_address
# from app.settings import DEBBY_DIRECT_TRUST_IFRAME_CHECKER_LOGIN, DEBBY_DIRECT_TRUST_IFRAME_CHECKER_PASSWORD
from app.settings import DEBBY_IFRAME_CHECKER_LOGIN, DEBBY_IFRAME_CHECKER_PASSWORD


class AutoruIframeCheckerEngine(BaseEngine):

    @staticmethod
    def _prepare_profile(policy, targetlist):

        args = '-l {} -p {}'.format(
            DEBBY_IFRAME_CHECKER_LOGIN,
            DEBBY_IFRAME_CHECKER_PASSWORD
        )
        profile = {"args": args}

        return profile


    @staticmethod
    def new_tasks_payloads_generator(project_id, scan_id=None):
        s = new_session()
        project = s.query(DebbyProject.engine, DebbyProject.save_to_db).filter(DebbyProject.id == project_id).first()
        s.close()

        targets = ["https://www.auto.ru"]

        payload = json.dumps({
            "engine": project.engine,
            "profile": AutoruIframeCheckerEngine._prepare_profile(None, targets),
            "save_to_db": project.save_to_db
        })

        yield (targets, payload)

    @staticmethod
    def send_alert_message(error):
        EMAIL_HOST = "outbound-relay.yandex.net"
        EMAIL_PORT = 25
        EMAIL_SENDER = 'procenkoeg@yandex-team.ru'
        EMAIL_RECEIVERS = ['procenkoeg@yandex-team.ru']

        try:
            f = open("/tmp/DEBBY_EMAIL_HOST_USERS")
            EMAIL_RECEIVERS = json.loads(f.read())
            f.close()
        except:
            pass

        s=smtplib.SMTP(EMAIL_HOST, EMAIL_PORT)
        msg  = '\\\n'
        msg += "From: debby@yandex-team.ru\n"
        msg += "Subject: ~~~ALERT~~~ Debby's Auto.ru Trust Iframe Checker\n\n"
        msg += "Check Trust url in Auto.ru\n"
        msg += "Error: {}\n".format(error)
        msg += "Also you can debug problem locally with script: https://github.yandex-team.ru/security/debby/blob/master/src/app/engines/auto_ru_iframe_checker.py\n"
        s.sendmail(EMAIL_SENDER,EMAIL_RECEIVERS,msg)
        s.quit()

    @staticmethod
    def scan_results_to_splunk_events(scan_results, task_id, only_enabled=False):
        """

        :param results:
        :param task_id:
        :param scan:
        :param project:
        :param policy:
        :return:
        """

        print("[AutoruIframeCheckerEngine] scan_results: {}".format(scan_results))

        events = list()

        session = new_session()
        task = session.query(DebbyTask).filter(DebbyTask.id == task_id).first()
        scan = session.query(DebbyScan).filter(DebbyScan.id == task.debbyscan_id).first()
        project = session.query(DebbyProject).filter(DebbyProject.id == scan.project_id).first()
        policy = session.query(DebbyPolicy).filter(DebbyPolicy.id == project.policy_id).first()
        tags = session.query(DebbyTag).filter(RelationProjectTag.project_id == project.id)\
                                      .filter(RelationProjectTag.tag_id == DebbyTag.id).all()
        session.close()

        tag_list = list([tag.value for tag in tags])

        succeed = (
            len(scan_results) != 0 and
            scan_results[-1].get("trusted_iframe") and
            scan_results[-1].get("trusted_iframe2") and
            scan_results[-1].get("yooMoneySDK") and
            scan_results[-1].get("success_auth") and
            not scan_results[-1].get("error")
        )

        if not succeed:
            AutoruIframeCheckerEngine.send_alert_message(scan_results[-1].get('error'))

        for res in scan_results:
            # print("res: {}".format(res))
            enabled = True

            if not enabled and only_enabled:
                continue

            if enabled:
                scripts = {
                    'iframe_checker_error': res.get("error"),
                    'iframe_checker_success_auth': res.get("success_auth"),
                    'iframe_checker_trusted_iframe': res.get("trusted_iframe"),
                    'iframe_checker_trusted_iframe2': res.get("trusted_iframe2"),
                    'iframe_checker_yooMoneySDK': res.get("yooMoneySDK"),
                    'iframe_checker_host': res.get("host"),
                    'iframe_checker_url': res.get("url"),
                    'iframe_checker_succeed': succeed
                }
            else:
                scripts = None

            events.append({
                'event_type': 'info',

                'projectId': project.id,
                'projectName': project.name,
                'engine': project.engine,
                'logClosed': project.log_closed,
                'tags': tag_list,

                'policyId': policy.id,

                'dest_ip': None,
                'dest_host': res.get("host"),
                'url': res.get("url"),
                'resp': None,
                'resp_source': None,
                'protocol': None,

                'dest_port': 443,
                'transport': PROTO_TCP,
                'time': None,
                'enabled': enabled,
                'scripts': scripts,

                'service_name': None,
                'service_product': None,
                'service_version': None,

                'scanId': scan.id,
                'scanStartTime': datetime_msk_2_timestamp_utc(scan.create_time),

                'taskId': task.id,
            })

        return events
