


class BaseEngine(object):

    @staticmethod
    def scan_init(*args, **kwargs):
        return None

    @staticmethod
    def task_init(*args, **kwargs):
        return None

    @staticmethod
    def scan_cleanup(*args, **kwargs):
        return None

    @staticmethod
    def task_cleanup(task, *args, **kwargs):
        return None

    @staticmethod
    def task_pre_run(payload, task_meta_info, *args, **kwargs):
        return payload

    @staticmethod
    def task_post_run(debby_task_id, task_meta_info, *args, **kwargs):
        return None

    @staticmethod
    def new_tasks_payloads_generator(project_id, scan_id=None):
        raise NotImplementedError

    # @classmethod
    # def new_tasks_payloads_generator_ex(cls, project_id, *args, **kwargs):
    #     for targets, payload in cls.new_tasks_payloads_generator(project_id, *args, **kwargs):
    #         yield (targets, payload)

    @staticmethod
    def scan_results_to_splunk_events(scan_results, task_id, only_enabled=True):
        raise NotImplementedError

    @staticmethod
    def cache_ports(task_results, project_name, scan_id, task_id, agent_id):
        return None
