


from app.db.models import MetaTable
from app.db.db import new_session


class MetaInfo(object):

    @staticmethod
    def set(key, value):
        s = new_session()
        kv = s.query(MetaTable).filter(MetaTable.key == key).first()
        if kv:
            kv.value = value
        else:
            kv = MetaTable(key=key, value=value)
            s.add(kv)
        s.commit()
        s.close()

    @staticmethod
    def get(key, default=None):
        ret_value = default
        s = new_session()
        kv = s.query(MetaTable).filter(MetaTable.key == key).first()
        if kv:
            ret_value = kv.value
        s.close()
        return ret_value

    @staticmethod
    def delete(key):
        s = new_session()
        s.query(MetaTable).filter(MetaTable.key == key).delete(synchronize_session='fetch')
        s.commit()
        s.close()
