

import time
import requests
import traceback
from tenacity import retry, stop_after_attempt, wait_exponential

from app.settings import INFRA_OAUTH_TOKEN, INFRA_SERVICE_ID, INFRA_ENV_ID, INFRA_ENABLED


@retry(stop=stop_after_attempt(3), wait=wait_exponential(multiplier=1, min=4, max=30), reraise=True)
def start_event_imp(scan_id):

    if not INFRA_ENABLED:
        return

    startTime = int(time.time())

    url = 'https://infra-api.yandex-team.ru/v1/events'
    headers = {"Authorization": "OAuth {}".format(INFRA_OAUTH_TOKEN)}
    payload = {
      "title": "Crasher/Molly Scan is in progress",
      "description": "Searching for vulnerabilities with Molly",
      "environmentId": INFRA_ENV_ID,
      "serviceId": INFRA_SERVICE_ID,
      "startTime": startTime,
      "finishTime": None,
      "type": "issue",
      "severity": "minor",
      "man": True,
      "myt": True,
      "sas": True,
      "vla": True,
      "iva": True,
      "tickets": "",
      "meta": {
        "scanId": scan_id,
      },
      "sendEmailNotifications": False,
      "setAllAvailableDc": False
    }

    r = requests.post(url, headers=headers, json=payload, verify=False)
    r.json()


def start_event(scan_id):
    try:
        start_event_imp(scan_id)
    except:
        traceback.print_exc()


@retry(stop=stop_after_attempt(3), wait=wait_exponential(multiplier=1, min=4, max=30), reraise=True)
def _get_event_id(scan_id):
    url = 'https://infra-api.yandex-team.ru/v1/events'
    headers = {"Authorization": "OAuth {}".format(INFRA_OAUTH_TOKEN)}
    params = {
      'serviceId': INFRA_SERVICE_ID,
      'environmentId': INFRA_ENV_ID,
    }

    r = requests.get(url, headers=headers, params=params, verify=False)
    events = r.json()
    events = list([e for e in events if e.get("meta").get("scanId") == scan_id])
    if len(events) > 0:
        return events[0]['id']
    else:
        return None


@retry(stop=stop_after_attempt(3), wait=wait_exponential(multiplier=1, min=4, max=30), reraise=True)
def stop_event_imp(scan_id):

    if not INFRA_ENABLED:
        return

    finishTime = int(time.time())

    event_id = _get_event_id(scan_id)

    if event_id:
        url = 'https://infra-api.yandex-team.ru/v1/events/{}'.format(event_id)
        headers = {"Authorization": "OAuth {}".format(INFRA_OAUTH_TOKEN)}
        payload = {"finishTime": finishTime}

        r = requests.put(url, headers=headers, json=payload, verify=False)
        j = r.json()


def stop_event(scan_id):
    try:
        stop_event_imp(scan_id)
    except:
        traceback.print_exc()
