

from flask import Blueprint, redirect, url_for, render_template, request, g

from app.db.models import Macro
from app.db.db import new_session
from .macro import MacroBaseObject
from app import yauth

bp = Blueprint('macros', __name__, url_prefix='/macros')


@bp.route('/', methods=['GET'])
@yauth.sessionid_required
# @yauth.admin_role_required
@yauth.require_role(yauth.ROLES_ADMIN)
def macros_main():
    session = new_session()
    macros_count = session.query(Macro.id, Macro.value).count()
    session.close()
    hardcoded = MacroBaseObject().get_hardcoded_keys()
    hardcoded_count = len(hardcoded)
    return render_template('macros_main.html', macros_count=macros_count,
                           hardcoded=hardcoded, hardcoded_count=hardcoded_count)


@bp.route('/<int:macro_id>', methods=['GET'])
@yauth.sessionid_required
# @yauth.admin_role_required
@yauth.require_role(yauth.ROLES_ADMIN)
def macro_details(macro_id):
    session = new_session()
    macro = session.query(Macro).filter(Macro.id == macro_id).first()
    session.close()
    return render_template('macro_details.html', macro=macro)
