

import os
import re
import ipaddress
import logging
import uuid
import requests
import traceback
import subprocess
from future.utils import iteritems

from app.db.db import new_session
from app.db.models import Macro
from app.settings import BULK_STATUS_INACTIVE, BULK_STATUS_ACTIVE
from app.utils import now


def fetch_golem_macros():
    # get macros info from golem
    try:
        resp = requests.get('http://hbf.yandex.net/dump-all-macros?net_only=0')
    except requests.ConnectionError:
        print('[+] Unable to fetch_macros')
        return

    macros = resp.json()

    # Remove old inactive macros
    session = new_session()
    session.query(Macro).filter(Macro.status == BULK_STATUS_INACTIVE).delete()
    session.commit()
    session.close()

    # prepare objects for bulk insert
    objects = []
    for (macro, addresses) in iteritems(macros):
        objects.append({"value": macro, "targets": ', '.join(addresses)})

        ## filter entries like 1517@2a02:6b8:c00::/40 by removing prefix before symbol '@'
        ## remain only uniq addrs/nets
        # addrs = set()
        # for addr in addresses:
        #     idx = addr.find("@")
        #     if idx == -1:
        #         addrs.add(addr)
        #     else:
        #         addrs.add(addr[idx+1:])
        # objects.append({"value": macro, "targets": ', '.join(addrs)})
        
    length = len(objects)

    session = new_session()
    # Bulk insert
    offset = 0
    block_size = 1000
    while offset < length:
        session.execute(
            Macro.__table__.insert().values(objects[offset:offset+block_size])
        )
        offset += block_size
    session.commit()
    session.close()

    # does it free allocation for objects memory???
    objects = None

    # go to new macros
    session = new_session()
    session.query(Macro).filter(Macro.status == BULK_STATUS_ACTIVE).delete()
    session.query(Macro).update({
        Macro.status: BULK_STATUS_ACTIVE,
        Macro.update_time: now()
    })
    session.commit()
    session.close()

def fetch_dnscache_targets(only_ipv6=True):
    try:
        # run ssh-agent for this task
        out = subprocess.check_output("ssh-agent", shell=True)
        ssh_agent_envs = re.findall(r"([A-Z_]*)=([^;]*)", out)
        # prepare env with SSH_AUTH_SOCK and SSH_AGENT_PID
        env = os.environ.copy()
        for ssh_agent_env in ssh_agent_envs:
            k, v = ssh_agent_env
            env[k] = v

        # add ssh key to access cvs
        subprocess.check_call("ssh-add /etc/ssh/robot-pika/id_rsa", shell=True, env=env)


        # create temp folder
        foldername = str(uuid.uuid4())
        filename = "{}/router.dnscache.full".format(foldername)

        # checkout dnscache
        cmd = 'cvs -d ":ext:robot-pika@tree.yandex.ru:/opt/CVSROOT" co -d {} noc/routers/fw/router.dnscache.full'.format(foldername)
        subprocess.check_call(cmd, shell=True, env=env)

        # read dnscache file
        f = open(filename, "r")
        data = f.read()
        f.close()

        # rm dnscache folder
        subprocess.check_call("rm -rf {}".format(foldername), shell=True)
        # clear ssh agent
        subprocess.check_call("ssh-agent -k", shell=True, env=env)

        # parse addresses
        ips = set()
        lines = data.split("\n")
        for line in lines:

            # skip empty lines
            parts = line.split(" ")
            if len(parts) < 2:
                continue

            ip_addresses = parts[1]
            parsed_ips = ip_addresses.split(",")
            for ip in parsed_ips:
                if only_ipv6:
                    func = ipaddress.IPv6Address
                else:
                    func = ipaddress.ip_address

                try:
                    func(ip)
                    ips.add(ip)
                except ValueError:
                    pass

        return list(ips)

    except subprocess.CalledProcessError as e:
        logging.debug("[!] fetch_dnscache_targets.Exception: {}".format(str(e)))
        traceback.print_exc()
        return None

    except Exception as e:
        logging.debug("[!] fetch_dnscache_targets.Exception: {}".format(str(e)))
        traceback.print_exc()
        return None
