import re
from flask import Blueprint, render_template, request, redirect, url_for, g
from app.db.db import new_session
from app.db.models import Namespace, DebbyProject
from app import yauth
from app.validators import DebbyRuntimeException, DebbyValidateException
from app.validators import validate_namespace
from app.projects.utils import get_projects, make_project_drawable

bp = Blueprint('namespaces', __name__, url_prefix='/namespaces')

@bp.route('/')
@yauth.sessionid_required
@yauth.require_role(yauth.ROLES_ADMIN)
def namespaces_main():

    session = new_session()
    db_namespaces = session.query(Namespace).order_by(Namespace.id).all()
    session.close()

    namespaces = [Namespace(id=0, name="Default (TRY TO NOT USE)", contacts="")] + db_namespaces

    return render_template('namespaces_main.html', namespaces=namespaces)

@bp.route('/new', methods=['GET', 'POST'])
@yauth.sessionid_required
@yauth.require_role(yauth.ROLES_ADMIN)
def namespaces_new():
    if request.method == 'GET':
        return render_template('namespaces_new.html')
    
    try:
        
        VARS = validate_namespace(request)
        if not VARS["contacts"] and "yalogin" in g:
            VARS["contacts"] = g.yalogin

        session = new_session()
        new_namespace = Namespace(name=VARS["name"], contacts=VARS["contacts"])
        session.add(new_namespace)
        session.flush()
        session.commit()
        session.close()

        return redirect(url_for('namespaces.namespaces_main'))

    # handle validation exception
    except DebbyValidateException as ex:
        error = 'DebbyValidateException: ' + repr(ex)
        return render_template('namespaces_new.html', error=error)


@bp.route('/<int:namespace_id>', methods=['DELETE'])
@yauth.sessionid_required
@yauth.require_role(yauth.ROLES_ADMIN)
def namespace_delete(namespace_id):

    # session = new_session()
    # session.query(DebbyProject).filter(DebbyProject.namespace_id == namespace_id).update({namespace_id:None})
    # session.commit()
    # session.close()

    session = new_session()
    session.query(Namespace).filter(Namespace.id == namespace_id).delete()
    session.commit()
    session.close()

    return redirect(url_for('namespaces.namespaces_main'))


@bp.route('/<int:namespace_id>/edit', methods=['GET', 'POST'])
@yauth.sessionid_required
@yauth.require_role(yauth.ROLES_ADMIN)
def namespace_edit(namespace_id):

    # Get info from db
    session = new_session()
    namespace = session.query(Namespace).filter(Namespace.id == namespace_id).first()
    session.close()

    if request.method == 'GET':
        return render_template('namespace_edit.html', namespace=namespace)

    try:

        VARS = validate_namespace(request)

        updating = {
            Namespace.name: VARS['name'],
            Namespace.contacts: VARS['contacts']
        }

        session = new_session()
        session.query(Namespace).filter(Namespace.id == namespace_id).update(updating)
        session.commit()
        session.close()

        return redirect(url_for('namespaces.namespaces_main'))

    except DebbyValidateException as ex:
        return render_template('namespace_edit.html', namespace=namespace, error=ex.args)


@bp.route('/<int:namespace_id>')
@yauth.sessionid_required
@yauth.require_role(yauth.ROLES_ADMIN)
def namespace_projects(namespace_id):

    namespace = Namespace(id=0, name="Default (TRY TO NOT USE)", contacts="")
    if namespace_id:
        session = new_session()
        namespace = session.query(Namespace).filter(Namespace.id == namespace_id).first()
        session.close()

    projects = get_projects(namespace_id=namespace_id)
    for project in projects:
        make_project_drawable(project)

    return render_template('projects_main.html', ns=namespace, projects=projects)
