

from app.db.db import new_session
from app.db.models import DebbyPolicy, DebbyPolicyScript, DebbyPolicyAdditionalOptions
from app.settings import PROTO_TCP
from app.validators import DebbyRuntimeException


def create_policy(name, scan_type, ports_list=None, spec_scripts=[], additional_options=None):
    """

    :param name: String
    :param ports_list: List
    :param scan_type: Enum/String
    :param spec_scripts: List
    :param additional_options:
    :return:
    """
    session = new_session()

    if not ports_list:
        ports_list = ''
    if not scan_type:
        scan_type = PROTO_TCP

    # create Policy
    dp = DebbyPolicy(name=name, ports=', '.join(ports_list), scan_type=scan_type)
    session.add(dp)
    session.flush()
    policy_id = dp.id

    # Add scripts for policy
    for script_name in spec_scripts:
        dps = DebbyPolicyScript(policy_id=policy_id, name=script_name)
        session.add(dps)

    # additional options
    if additional_options:
        dpao = DebbyPolicyAdditionalOptions(policy_id=policy_id, value=additional_options)
        session.add(dpao)

    session.commit()
    session.close()

    return policy_id


def edit_policy(policy_id, name, scan_type, ports_list=None, spec_scripts=[], additional_options=None):
    """

    :param policy_id:
    :param name:
    :param scan_type:
    :param ports_list:
    :param spec_scripts:
    :param additional_options:
    :return:
    """
    session = new_session()

    if not ports_list:
        ports_list = ''
    if not scan_type:
        scan_type = PROTO_TCP

    policy = session.query(DebbyPolicy).filter(DebbyPolicy.id == policy_id).first()
    if not policy:
        raise DebbyRuntimeException('Unknown policy id')

    # update policy itself
    policy.name = name
    policy.ports = ', '.join(ports_list)
    policy.scan_type = scan_type

    # delete previous scripts
    session.query(DebbyPolicyScript).filter(DebbyPolicyScript.policy_id==policy_id).delete()
    # Add scripts for policy
    for script_name in spec_scripts:
        dps = DebbyPolicyScript(policy_id=policy_id, name=script_name)
        session.add(dps)

    # delete previous addopts
    session.query(DebbyPolicyAdditionalOptions).filter(DebbyPolicyAdditionalOptions.policy_id==policy_id).delete()
    # additional options
    if additional_options:
        dpao = DebbyPolicyAdditionalOptions(policy_id=policy_id, value=additional_options)
        session.add(dpao)

    session.commit()
    session.close()


def get_policy_by_uuid(uuid):
    """

    :param name: String
    :return:
    """
    # get Policy
    session = new_session()
    policy = session.query(DebbyPolicy).filter(DebbyPolicy.uuid == uuid).first()
    session.close()

    return policy
