# from __future__ import unicode_literals, absolute_import, print_function


import os
import json
import random
import string
import urllib3


POSITIVE_OPTIONS = ['True', 'TRUE', 'true', 't', '1', 'y', 'yes', 'YES', 'Yes']


# ----------------------------------------------
# --- DISABLE THE MOST ANNOING WARNINGS EVER ---
# ----------------------------------------------

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

# ----------------
# --- Database ---
# ----------------
try:
    DB_URLS = json.loads(os.getenv('DEBBY_DB_URLS', None))
except TypeError:
    DB_URLS = ["postgresql://ivre_user:ivre_pass@localhost:5432/ivre_db"]

# DB_CURRENT_MASTER_IDX = 0
DB_CONNECT_ARGS = {'sslmode': 'verify-full'} if (os.getenv('DEBBY_DB_VERIFY_FULL') in POSITIVE_OPTIONS) else None

# ------------------
# --- SECRET KEY ---
# ------------------

SECRET_KEY = os.getenv('DEBBY_SECRET_KEY', None)
if not SECRET_KEY:
    try:
        SECRET_KEY = ''.join(random.choice(string.letters + string.digits) for _ in range(128))
    except AttributeError:
        SECRET_KEY = ''.join(random.choice(string.ascii_letters + string.digits) for _ in range(128))

# --------------
# --- Splunk ---
# --------------

HEC_TOKEN = os.getenv('DEBBY_HEC_TOKEN', '')
HEC_HOST = os.getenv('DEBBY_HEC_HOST', 'hatch.yandex.net')

# -----------
# --- CRT ---
# -----------

CRT_TOKEN = os.getenv('CRT_TOKEN', '')
CRT_API_URL = os.getenv('CRT_API_URL', 'https://crt-api.yandex-team.ru/api/v2/certificates/')

# ----------------------
# --- Authentication ---
# ----------------------

def get_string_and_split(env_var, default=None):
    values = os.getenv(env_var)
    if not values:
        return default
    if values:
        try:
            return values.split(",")
        except:
            return default

def get_debby_admins():
    defaults = ['procenkoeg', 'anton-k', 'ezaitov', 'a-abakumov', 'shikari', "aleksei-m", "melkikh"]
    return get_string_and_split("DEBBY_ADMINS", defaults)

def get_private_api_users():
    defaults = ['procenkoeg']
    return get_string_and_split("PRIVATE_API_USERS", defaults)

def get_public_api_users():
    core_team = [
        "ezaitov", "a-abakumov", "shikari", "anton-k", "asuhanov"
        "buglloc", "horus", "procenkoeg", "melkikh", "ilyaon"
    ]
    service_team = [
        "shashial", "ybuchnev",
        "a-zhabolenko", "kaleda", "a-konyshev", "axlodin",
        "aleksei-m", "naumov-al", "audap",
    ]
    soc_team = [
        "gots", "energen", "antonkalinin", "limetime",
        "spellanser", "strawberry", "dmrussak"
    ]
    other_public_api_users = ["robot-checker", "robot-bishop", "robot-znoc"]
    defaults = core_team + service_team + soc_team + other_public_api_users
    return get_string_and_split("PUBLIC_API_USERS", defaults)


# DEBBY_SITE = os.getenv('DEBBY_SITE', 'https://debby.sec.yandex-team.ru') 
DEBBY_SITE = os.getenv('DEBBY_SITE') 
DEBBY_SKIP_YAUTH = os.getenv('DEBBY_SKIP_YAUTH') in POSITIVE_OPTIONS
ADMINS = get_debby_admins()
PRIVATE_API_USERS = get_private_api_users()
PUBLIC_API_USERS = get_public_api_users()

# -----------
# --- TVM ---
# -----------

# deploy or qloud
TVM_TOOL_URL = os.getenv("DEPLOY_TVM_TOOL_URL") or "http://localhost:1"
TVM_TOOL_AUTHTOKEN = os.getenv('TVMTOOL_LOCAL_AUTHTOKEN') or os.getenv('QLOUD_TVM_TOKEN')
TVM_CLIENT_SECRET = os.getenv("TVM_CLIENT_SECRET")
TVM_DISK_CACHE_DIR = os.getenv('TVM_DISK_CACHE_DIR', '/usr/lib/debby_console/.tvmcache')
TIROLE_IDM_SYSTEM = os.getenv('TIROLE_IDM_SYSTEM', 'debby-prod')
DEBBY_TVM_ID = 2002104
BLACKBOX_TVM_ID = 223
DEBBY_TARGETS_TVM_ID = 2025624
WAFFLES_TVM_ID = 2008801
# DEBBY_API_TVM_CLIENTS = [DEBBY_TVM_ID]
# for tests
DEBBY_TVM_TICKET = os.getenv('DEBBY_TVM_TICKET')
BLACKBOX_TVM_TICKET = os.getenv('BLACKBOX_TVM_TICKET')

# -------------
# --- Molly ---
# -------------

MOLLY_OAUTH_TOKEN = os.getenv('MOLLY_OAUTH_TOKEN')
MOLLY_DEFAULT_AUTH_PROFILE = os.getenv('MOLLY_DEFAULT_AUTH_PROFILE', '')

# ---------------
# --- GLOBALS ---
# ---------------

# --- Agent Client Types --- #
AGENT_CLIENT_TYPE_DEBBY = 'DEBBY'
AGENT_CLIENT_TYPE_MOLLY = 'MOLLY'
AGENT_CLIENT_TYPE_OPENVAS = 'OPENVAS'
AGENT_CLIENT_TYPE_OPENVAS_2 = 'OPENVAS_2'

# --- Task States --- #
STATE_PENDING = 'pending'
STATE_IN_PROGRESS = 'in progress'
STATE_CANCELED = 'canceled'
STATE_FINISHED = 'finished'
STATE_ABORTED = 'aborted'
STATES_ALIVE = [STATE_PENDING, STATE_IN_PROGRESS]
STATES_DEAD = [STATE_CANCELED, STATE_FINISHED, STATE_ABORTED]
STATES_FAILED = [STATE_CANCELED, STATE_ABORTED]
STATE_TYPE_ALIVE = 'alive'
STATE_TYPE_DEAD = 'dead'
STATE_TYPE_UNKNOWN = 'unknown'

# --- Engines --- #
# ENGINE_IVRE = 'ivre'
ENGINE_NMAP = 'nmap'
ENGINE_CLICKHOUSECHECKER = 'clickhousechecker'
ENGINE_DIRECT_TRUST_IFRAME_CHECKER = 'direct_trust_iframe_checker'
ENGINE_AUTO_RU_IFRAME_CHECKER = 'auto_ru_iframe_checker'
ENGINE_REALTY_IFRAME_CHECKER = 'realty_iframe_checker'
ENGINE_PAY_IFRAME_CHECKER = 'pay_iframe_checker'
ENGINE_MONGO_CHECKER = 'mongo_checker'
ENGINE_REDIS_CHECKER = 'redis_checker'
ENGINE_IPMI_CHECKER = 'ipmi_checker'
ENGINE_MOLLY = 'molly'
ENGINE_OPENVAS = 'openvas'
ENGINE_OPENVAS_2 = 'openvas_2'
ENGINE_SSH_KEY_CHECKER = 'ssh_key_checker'
ENGINE_DOCKER_CHECKER = 'docker_checker'
ENGINE_ZOOKEEPER_CHECKER = 'zookeeper_checker'
ENGINES = [
    ENGINE_NMAP, ENGINE_MOLLY, ENGINE_OPENVAS_2,
    # ENGINE_NMAP, ENGINE_MOLLY, ENGINE_OPENVAS, ENGINE_OPENVAS_2,
    ENGINE_CLICKHOUSECHECKER, ENGINE_MONGO_CHECKER, ENGINE_REDIS_CHECKER,
    ENGINE_IPMI_CHECKER, ENGINE_SSH_KEY_CHECKER, ENGINE_PAY_IFRAME_CHECKER,
    ENGINE_DIRECT_TRUST_IFRAME_CHECKER, ENGINE_AUTO_RU_IFRAME_CHECKER,
    ENGINE_REALTY_IFRAME_CHECKER, ENGINE_DOCKER_CHECKER, ENGINE_ZOOKEEPER_CHECKER
]
API_ENGINES = [
    ENGINE_NMAP, ENGINE_CLICKHOUSECHECKER, ENGINE_MONGO_CHECKER,
    ENGINE_REDIS_CHECKER, ENGINE_OPENVAS_2
]

# ---------------------
# --- Nmap Specific ---
# ---------------------
# --- XXX --- #
MAX_TARGETS_PER_TASK_NMAP = 128
# --- Available for using nmap scripts --- #
AVAILABLE_NMAP_SCRIPTS = ['banner']

# --- Enable types --- #
ENABILITY_TYPE_NONE = 'none'
ENABILITY_TYPE_ONLY_ENABLED = 'only_enabled'
ENABILITY_TYPE_ONLY_NOT_ENABLED = 'only_not_enabled'
ENABILITY_TYPE_ALL = 'all'

# --- Protocols --- #
PROTO_IPV4 = 'ipv4'
PROTO_IPV6 = 'ipv6'
NETWORK_PROTOCOLS = [PROTO_IPV4, PROTO_IPV6]

PROTO_TCP = 'tcp'
PROTO_UDP = 'udp'
TRANSPORT_PROTOCOLS = [PROTO_TCP, PROTO_UDP]

# --- IP addesses bulks statuses --- #
BULK_STATUS_INACTIVE = 'inactive'
BULK_STATUS_ACTIVE = 'active'

# --- Splunk event types --- #
EVENT_TYPE_INFO = 'info'
EVENT_TYPE_STATE_CHANGE = 'state_change'

# --- Default Yandex IPv6 nets --- #
# --- these ones used when _YANDEXNETS6_ is anavailable --- #
DEFAULT_YANDEXNETS6 = ["2620:10f:d000::/44", "2a02:6b8::/32"]

# -------------
# --- Locks ---
# -------------

LOCK_AGENTS = 'LOCK_AGENTS'

# -----------
# --- API ---
# -----------

# DONT_CHECK_SERVICE_TICKETS = os.getenv('DONT_CHECK_SERVICE_TICKETS') in POSITIVE_OPTIONS
DONT_CHECK_API_AUTH = os.getenv('DONT_CHECK_API_AUTH') in POSITIVE_OPTIONS
API_PROJECTS_LIMIT = 4
API_TAG = 'API'
API_PREFIX = '[API]_'

# -------------
# --- Infra ---
# -------------

INFRA_OAUTH_TOKEN = os.getenv('INFRA_OAUTH_TOKEN')
INFRA_SERVICE_ID = 497
INFRA_ENV_ID = 780
INFRA_ENABLED = os.getenv('INFRA_ENABLED') in POSITIVE_OPTIONS

# ---------------
# --- Solomon ---
# ---------------

SOLOMON_OAUTH_TOKEN = os.getenv('SOLOMON_OAUTH_TOKEN')
ENABLE_SOLOMON_MONITORING = os.getenv('ENABLE_SOLOMON_MONITORING', '1') in POSITIVE_OPTIONS
# SOLOMON_SEND_SENSORS = os.getenv('SOLOMON_SEND_SENSORS', '1') in POSITIVE_OPTIONS

# ------------------------------------------
# --- DIRECT_TRUST_IFRAME_CHECKER_ENGINE ---
# ------------------------------------------

# DIRECT_TRUST_IFRAME_CHECKER_ENGINE_SESSION = os.getenv('DIRECT_TRUST_IFRAME_CHECKER_ENGINE_SESSION')
# DIRECT_TRUST_IFRAME_CHECKER_ENGINE_SESSION2 = os.getenv('DIRECT_TRUST_IFRAME_CHECKER_ENGINE_SESSION2')
DEBBY_DIRECT_TRUST_IFRAME_CHECKER_LOGIN = os.getenv('DEBBY_DIRECT_TRUST_IFRAME_CHECKER_LOGIN')
DEBBY_DIRECT_TRUST_IFRAME_CHECKER_PASSWORD = os.getenv('DEBBY_DIRECT_TRUST_IFRAME_CHECKER_PASSWORD')
DEBBY_IFRAME_CHECKER_LOGIN = os.getenv('DEBBY_IFRAME_CHECKER_LOGIN')
if not DEBBY_IFRAME_CHECKER_LOGIN:
    DEBBY_IFRAME_CHECKER_LOGIN = os.getenv('DEBBY_DIRECT_TRUST_IFRAME_CHECKER_LOGIN')
DEBBY_IFRAME_CHECKER_PASSWORD = os.getenv('DEBBY_IFRAME_CHECKER_PASSWORD')
if not DEBBY_IFRAME_CHECKER_PASSWORD:
    DEBBY_IFRAME_CHECKER_PASSWORD = os.getenv('DEBBY_DIRECT_TRUST_IFRAME_CHECKER_PASSWORD')


# ---------------
# --- PUNCHER ---
# ---------------

# https://wiki.yandex-team.ru/noc/nocdev/puncher/api/
PUNCHER_OAUTH_TOKEN = os.getenv('PUNCHER_OAUTH_TOKEN')


# -------------
# --- QLOUD ---
# -------------

QLOUD_OAUTH_TOKEN = os.getenv("DEBBY_QLOUD_OAUTH_TOKEN")


# ----------
# --- ST ---
# ----------

ROBOT_ST_OAUTH_TOKEN = os.getenv("ROBOT_ST_OAUTH_TOKEN")
ST_DEBBY_CONSOLE_USER_AGENT = "debby-console"

# ----------------
# --- FEATURES ---
# ----------------

FEATURE_ENABLE_DEBBY_TARGETS = os.getenv("FEATURE_ENABLE_DEBBY_TARGETS", "1") in POSITIVE_OPTIONS
FEATURE_ENABLE_SEND_RESULTS_TO_SPLUNK = os.getenv("FEATURE_ENABLE_SEND_RESULTS_TO_SPLUNK", "1") in POSITIVE_OPTIONS
FEATURE_ENABLE_SEND_OPENVAS_REPORT_TO_ST = os.getenv("FEATURE_ENABLE_SEND_OPENVAS_REPORT_TO_ST", "1") in POSITIVE_OPTIONS
