
import datetime
from celery.schedules import crontab

# --------------------------------------------------------------------
# http://docs.celeryproject.org/en/latest/userguide/configuration.html
# --------------------------------------------------------------------

BROKER_URL = 'redis://localhost:6377/0'
CELERY_IMPORTS = ('app.tasks', )


CELERYBEAT_SCHEDULE = {
    # 'get_agents_jobs_count': {
    #     'task': 'app.tasks.get_agents_jobs_count',
    #     'schedule': datetime.timedelta(seconds=3),
    #     'options': {
    #         'expires': 3
    #     }
    # },
    'update_working_tasks_info': {
        'task': 'app.tasks.update_working_tasks_info',
        'schedule': datetime.timedelta(seconds=15),
        'options': {
            'expires': 15,
        },    
    },
    'run_scheduled_projects': {
        'task': 'app.tasks.run_scheduled_projects',
        'schedule': datetime.timedelta(seconds=15),
        'options': {
            'expires': 15,
        },    
    },
    # 'fetch_ipv6_addresses': {
    #     'task': 'app.tasks.fetch_ipv6_addresses',
    #     'schedule': datetime.timedelta(seconds=60*60),
    #     'options': {
    #         'expires': 60*60,
    #     },    
    # },
    'fetch_macros': {
        'task': 'app.tasks.fetch_macros',
        'schedule': datetime.timedelta(seconds=60*60),
        'options': {
            'expires': 60*60,
        },    
    },
    'agents_jobs_fix': {
        'task': 'app.tasks.agents_jobs_fix',
        'schedule': datetime.timedelta(seconds=5*60),
        'options': {
            'expires': 5*60,
        },
    },
    'solomon_routine_task': {
        'task': 'app.tasks.solomon_routine_task',
        'schedule': datetime.timedelta(seconds=60*5),
        'options': {
            'expires': 60*3,
        },    
    },
    'solomon_daily_routine_task': {
        'task': 'app.tasks.solomon_daily_routine_task',
        'schedule': crontab(0, 7),
        'options': {
            'expires': 60,
        },    
    },
    'solomon_weekly_routine_task': {
        'task': 'app.tasks.solomon_weekly_routine_task',
        'schedule': crontab(0, 7, day_of_week=2),
        'options': {
            'expires': 60,
        },    
    },
    'autocancel_long_scans': {
        'task': 'app.tasks.autocancel_long_scans',
        'schedule': datetime.timedelta(seconds=60),
        'options': {
            'expires': 59,
        },    
    },
    'clear_old_cache_and_vacuum': {
        'task': 'app.tasks.clear_old_cache_and_vacuum',
        'schedule': datetime.timedelta(days=1),
        'options': {
            'expires': 60,
        },
    },
}
