# import requests
# import traceback

import tvmauth

from app.settings import TVM_TOOL_AUTHTOKEN, TVM_TOOL_URL, TVM_CLIENT_SECRET
from app.settings import DEBBY_TVM_ID, WAFFLES_TVM_ID, BLACKBOX_TVM_ID, DEBBY_TARGETS_TVM_ID
from app.settings import BLACKBOX_TVM_TICKET, DEBBY_TVM_TICKET
from app.settings import TVM_DISK_CACHE_DIR, TIROLE_IDM_SYSTEM
# from app.settings import DEBBY_API_TVM_CLIENTS


# def check_tvm_ticket_qloud(ticket):
#     try:
#         url = '{}/tvm/checksrv'.format(TVM_TOOL_URL)
#         headers = {
#             'Authorization': TVM_TOOL_AUTHTOKEN,
#             'X-Ya-Service-Ticket': ticket
#         }
#         data = {
#             'dst': DEBBY_TVM_TICKET
#         }

#         resp = requests.get(url, headers=headers, data=data).json()
#         src_tvm_id = resp.get('src')
#         if src_tvm_id in DEBBY_API_TVM_CLIENTS:
#             return src_tvm_id

#     except:
#         print('[!!!] check_tvm_ticket. Exception.')
#         traceback.print_exc()

#     return None


# def check_tvm_ticket_tvmapi(ticket):
#     client = tp2.TvmClient(tp2.TvmApiClientSettings(
#         self_client_id=DEBBY_TVM_ID,
#         enable_service_ticket_checking=True
#     ))
#
#     st = client.check_service_ticket(ticket)
#
#     if st and st.src:
#         return st.src
#     else:
#         return None


# def check_tvm_ticket(ticket):
#     src_tm_id = check_tvm_ticket_qloud(ticket)
#     return src_tm_id
    # if src_tm_id:
    #     return src_tm_id
    # else:
    #     return check_tvm_ticket_tvmapi(ticket)

# works in Python 2 & 3
class _Singleton(type):
    """ A metaclass that creates a Singleton base class when called. """
    _instances = {}
    def __call__(cls, *args, **kwargs):
        if cls not in cls._instances:
            cls._instances[cls] = super(_Singleton, cls).__call__(*args, **kwargs)
        return cls._instances[cls]

class Singleton(_Singleton('SingletonMeta', (object,), {})): pass

class TvmClient(Singleton):
    tvm_cli = None

    @classmethod
    def get(cls):
        if cls.tvm_cli:
            return cls.tvm_cli
        cls.tvm_cli = tvmauth.TvmClient(
            tvmauth.TvmApiClientSettings(
                self_tvm_id=DEBBY_TVM_ID,
                # localhost_port=2,
                # enable_service_ticket_checking=True,
                self_secret=TVM_CLIENT_SECRET,
                disk_cache_dir=TVM_DISK_CACHE_DIR,
                fetch_roles_for_idm_system_slug=TIROLE_IDM_SYSTEM,
                dsts={
                    "bb": BLACKBOX_TVM_ID,
                    "debby-targets": DEBBY_TARGETS_TVM_ID,
                    "waffles": WAFFLES_TVM_ID
                }
            )
        )
        return cls.tvm_cli


# def gen_tvm_ticket(dst_tvm_id):
#     url = '{}/tvm/tickets'.format(TVM_TOOL_URL)
#     headers = {'Authorization': TVM_TOOL_AUTHTOKEN}
#     params = {'src': DEBBY_TVM_ID, 'dsts': dst_tvm_id}
#     r = requests.get(url, headers=headers, params=params)
#     return list(r.json().values())[0]['ticket']


def get_waffles_tvm_ticket():
    return TvmClient().get().get_service_ticket_for("waffles")
    # tvm_ticket = DEBBY_TVM_TICKET
    # if not tvm_ticket:
    #     tvm_ticket = gen_tvm_ticket(WAFFLES_TVM_ID)
    # return tvm_ticket


def get_blackbox_tvm_ticket():
    return TvmClient().get().get_service_ticket_for("bb")
    # tvm_ticket = BLACKBOX_TVM_TICKET
    # if not tvm_ticket:
    #     tvm_ticket = gen_tvm_ticket(BLACKBOX_TVM_ID)
    # return tvm_ticket


def get_debby_targets_tvm_ticket():
    return TvmClient().get().get_service_ticket_for("debby-targets")
    # return gen_tvm_ticket(DEBBY_TARGETS_TVM_ID)
