

import time
import datetime
from collections import Counter
from app.db.db import new_session
from app.db.models import DebbyAgent, DebbyProject, DebbyScan, DebbyTask, UnistatTable
from app.settings import STATES_ALIVE, STATES_DEAD
from app.settings import ENGINE_MOLLY


def get_unistat():

    # time measurement
    start_time = time.time()

    s = new_session()
    agents = s.query(DebbyAgent.id, DebbyAgent.name, DebbyAgent.jobs).all()
    projects = s.query(DebbyProject.id, DebbyProject.name, DebbyProject.engine).filter(DebbyProject.deleted == False).all()
    scans = s.query(DebbyScan.id, DebbyScan.project_id).filter(DebbyScan.state.in_(STATES_ALIVE)).all()
    s.close()

    # count current jobs for every agent
    unistat_agents = list([[
            "ctype=agentjobs;agent_{}_{}_max".format(agent.id, agent.name),     # key
            agent.jobs  # value
        ] for agent in agents])

    # boolean status of working projects
    # 1 - for currently running
    # 0 - for not currently running
    working_projects = list([scan.project_id for scan in scans])
    unistat_projects = list([[
            "ctype=projectinwork;project_{}_{}_max".format(project.id, project.name),   # key
            int(project.id in working_projects)     # value
        ] for project in projects])

    # molly tasks states monitoring
    # s = new_session()

    # molly_projects = list(filter(lambda p: p.engine == ENGINE_MOLLY, projects))
    # molly_projects_ids = list(map(lambda p: p.id, molly_projects))
    # molly_scans = s.query(DebbyScan.id, DebbyScan.project_id).filter(DebbyScan.project_id.in_(molly_projects_ids)).all()
    # # molly_scans = list(filter(lambda s: s.project_id in molly_projects_ids, scans))
    # molly_scans_ids = list(map(lambda s: s.id, molly_scans))
    # unistat_molly_tasks_states_counter = list()

    # molly_tasks = s.query(DebbyTask.state).filter(DebbyTask.debbyscan_id.in_(molly_scans_ids)).all()
    # c = Counter(map(lambda task: task.state, molly_tasks))

    # for alive_state in STATES_ALIVE:

    #     counter =  c.get(alive_state, 0)

    #     unistat_molly_tasks_states_counter.append([
    #         "ctype=molly_tasks_states_counter;molly_state_{}_max".format(alive_state.replace(" ", "_")),
    #         counter
    #     ])

    # for dead_state in STATES_DEAD:

    #     counter =  c.get(dead_state, 0)

    #     prev_counter = s.query(UnistatTable)\
    #                     .filter(UnistatTable.key == dead_state)\
    #                     .first()

    #     if not prev_counter:
    #         diff_counter = 0
    #         s.add(UnistatTable(key=dead_state, value=counter))
    #         s.commit()
    #     else:
    #         diff_counter = counter - prev_counter.value
    #         prev_counter.value = counter
    #         s.commit()

    #     unistat_molly_tasks_states_counter.append([
    #         "ctype=molly_tasks_states_counter;molly_state_{}_max".format(dead_state),
    #         max(diff_counter, 0)
    #     ])

    # s.close()

    # time measurement
    finish_time = time.time()
    unistat_timeout = [[
        "ctype=unistat_timeout;unistat_timeout_ms_max",
        int(round((finish_time - start_time) * 1000))
    ]]

    unistat = unistat_agents + unistat_projects + unistat_timeout # + unistat_molly_tasks_states_counter
    return unistat
