

import sys
import uuid

from celery.bin import beat, worker
from future.utils import iteritems

from app.db.db import init_tables, drop_tables, refresh_tables, new_session
from app.db.models import DebbyPolicy, DebbyTag
from app.tasks import celery_app, fetch_macros
from app.settings import PROTO_TCP, PROTO_UDP, API_TAG


def run_celery_beat():
    beat_ = beat.beat(app=celery_app)
    options = {
        'loglevel': 'WARNING',
        'traceback': True,
        'hostname': str(uuid.uuid4()),
        'concurrency': 1,
        # 'logfile': 'log'
    }
    beat_.run(**options)


def run_celery_worker():
    worker_ = worker.worker(app=celery_app)
    options = {
        'loglevel': 'WARNING',
        'traceback': True,
        'hostname': str(uuid.uuid4()),
        'concurrency': 10,
        # 'logfile': 'log'
    }
    worker_.run(**options)


def fill_db():

    main_ports_dict = [21, 22, 53, 69, 80, 123, 443, 445, 623, 1521, 
                       2198, 3306, 5120, 5900, 5901, 7578, 8000, 8080]
    main_ports = ', '.join(str(port) for port in main_ports_dict)

    etc_service_tcp_ports_dict = [1, 7, 9, 11, 13, 15, 17, 18, 19, 20, 21, 22, 23, 25, 37, 42, 43, 49, 50, 53,
                                  65, 67, 68, 70, 79, 80, 87, 88, 95, 101, 102, 104, 105, 107, 110, 111, 113, 115,
                                  119, 123, 129, 135, 137, 138, 139, 143, 161, 162, 163, 164, 174, 177, 178, 179,
                                  194, 199, 201, 202, 204, 206, 209, 210, 213, 345, 346, 347, 369, 370, 371, 372,
                                  389, 406, 427, 443, 444, 445, 464, 465, 487, 500, 554, 607, 610, 611, 612, 628,
                                  631, 512, 513, 514, 515, 526, 530, 531, 532, 538, 540, 543, 544, 546, 547, 548,
                                  549, 556, 563, 587, 636, 655, 706, 749, 765, 873, 989, 990, 992, 993, 995, 1080,
                                  1093, 1094, 1194, 1099, 1214, 1241, 1352, 1433, 1434, 1524, 1645, 1646, 1649, 1677,
                                  1701, 1812, 1813, 1863, 1957, 1958, 1959, 2000, 2010, 2049, 2086, 2101, 2119,
                                  2135, 2401, 2430, 2431, 2432, 2433, 2583, 2628, 2792, 2811, 2947, 3050, 3130, 3205,
                                  3260, 3306, 3493, 3632, 3689, 3690, 4031, 4094, 4190, 4369, 4373, 4353, 4569, 4691,
                                  4899, 5002, 5050, 5060, 5061, 5190, 5222, 5269, 5308, 5353, 5432, 5556, 5671, 5672,
                                  5688, 6000, 6001, 6002, 6003, 6004, 6005, 6006, 6007, 6346, 6347, 6444, 6445, 6446,
                                  6697, 7000, 7001, 7002, 7003, 7004, 7005, 7006, 7007, 7008, 7009, 7100, 8080, 8140,
                                  9101, 9102, 9103, 9667, 10809, 10050, 10051, 10080, 11112, 11371, 13720, 13721,
                                  13722, 13724, 13782, 13783, 17500, 22125, 22128, 22273, 750, 751, 754, 760, 901,
                                  1109, 2053, 2105, 2111, 2121, 871, 1127, 98, 106, 775, 777, 783, 808, 1001, 1178,
                                  1236, 1300, 1313, 1314, 1529, 2003, 2121, 2150, 2600, 2601, 2602, 2603, 2604, 2605,
                                  2606, 2607, 2608, 2988, 2989, 4224, 4557, 4559, 4600, 4949, 5051, 5052, 5151, 5354,
                                  5355, 5666, 5667, 5674, 5675, 5680, 6514, 6566, 6667, 8021, 8081, 8088, 8990, 9098,
                                  9418, 9673, 10000, 10081, 10082, 10083, 11201, 15345, 17004, 20011, 20012, 24554,
                                  27374, 30865, 57000, 60177, 60179]
    etc_service_tcp_ports_dict = list(set(etc_service_tcp_ports_dict))
    etc_service_tcp_ports = ', '.join(str(port) for port in etc_service_tcp_ports_dict)

    etc_service_udp_ports_dict = [7, 9, 13, 18, 19, 21, 37, 39, 49, 50, 53, 65, 67, 68, 69, 88, 104, 105, 107,
                                  111, 123, 129, 135, 137, 138, 139, 161, 162, 163, 164, 174, 177, 178, 194, 199,
                                  201, 202, 204, 206, 209, 210, 213, 345, 346, 347, 369, 370, 371, 372, 389, 406,
                                  427, 444, 445, 464, 487, 500, 554, 607, 610, 611, 612, 623, 628, 631, 512, 513,
                                  514, 517, 518, 520, 525, 533, 538, 546, 547, 548, 549, 636, 655, 706, 765, 1080,
                                  1093, 1094, 1194, 1099, 1214, 1241, 1352, 1433, 1434, 1524, 1645, 1646, 1649,
                                  1677, 1701, 1812, 1813, 1863, 2000, 2049, 2086, 2101, 2119, 2135, 2401, 2430,
                                  2431, 2432, 2433, 2583, 2628, 2792, 2811, 2947, 3050, 3130, 3205, 3306, 3493,
                                  3632, 3689, 3690, 4031, 4094, 4369, 4373, 4353, 4500, 4569, 4691, 4899, 5002,
                                  5050, 5060, 5061, 5190, 5222, 5269, 5308, 5353, 5432, 5556, 5672, 5688, 6000,
                                  6001, 6002, 6003, 6004, 6005, 6006, 6007, 6346, 6347, 6444, 6445, 6446, 6696,
                                  7000, 7001, 7002, 7003, 7004, 7005, 7006, 7007, 7008, 7009, 7100, 8080, 9101,
                                  9102, 9103, 9667, 10050, 10051, 10080, 11371, 13720, 13721, 13722, 13724, 13782,
                                  13783, 22273, 750, 751, 752, 2102, 2103, 2104, 106, 779, 808, 1001, 1210, 2150,
                                  2988, 2989, 5354, 5355, 5555, 8088, 9359, 10081, 11201, 15345, 17001, 17002,
                                  17003, 20011, 20012, 27374]
    etc_service_udp_ports_dict = list(set(etc_service_udp_ports_dict))
    etc_service_udp_ports = ', '.join(str(port) for port in etc_service_udp_ports_dict)

    s = new_session()

    s.add(DebbyPolicy(name='MAIN TCP',         ports=main_ports,            scan_type=PROTO_TCP))
    s.add(DebbyPolicy(name='MAIN UDP',         ports=main_ports,            scan_type=PROTO_UDP))
    s.add(DebbyPolicy(name='SSH ONLY',         ports='22',                  scan_type=PROTO_TCP))
    s.add(DebbyPolicy(name='HTTP/HTTPS',       ports='80,443',              scan_type=PROTO_TCP))
    s.add(DebbyPolicy(name='ALL TCP',          ports='1-65535',             scan_type=PROTO_TCP))
    s.add(DebbyPolicy(name='ALL UDP',          ports='1-65535',             scan_type=PROTO_UDP))
    s.add(DebbyPolicy(name='ETC_SERVICES TCP', ports=etc_service_tcp_ports, scan_type=PROTO_TCP))
    s.add(DebbyPolicy(name='ETC_SERVICES UDP', ports=etc_service_udp_ports, scan_type=PROTO_UDP))
    s.add(DebbyPolicy(name='HTTP ONLY',  ports='80',  scan_type=PROTO_TCP, uuid='00000000-0000-0000-0000-000000000080'))
    s.add(DebbyPolicy(name='HTTPS ONLY', ports='443', scan_type=PROTO_TCP, uuid='00000000-0000-0000-0000-000000000443'))

    s.add(DebbyTag(value='INTERNAL'))
    s.add(DebbyTag(value='EXTERNAL'))
    s.add(DebbyTag(value='IPv4'))
    s.add(DebbyTag(value='IPv6'))
    s.add(DebbyTag(value='MOLLY'))
    s.add(DebbyTag(value='YACLOUD'))
    s.add(DebbyTag(value='AZURE'))
    s.add(DebbyTag(value='GUEST'))
    s.add(DebbyTag(value=API_TAG))
    s.add(DebbyTag(value='_'.join(['NOT', API_TAG])))
    s.add(DebbyTag(value='OPENVAS'))
    s.add(DebbyTag(value='OPENVAS_2'))

    s.commit()
    s.close()


# def fetch_macros():
#     fetch_macros.apply()


# def fetch_ipv6():
#     fetch_ipv6_addresses.apply()


COMMANDS = {
    'initdb': init_tables,
    'dropdb': drop_tables,
    'refreshdb': refresh_tables,
    'filldb': fill_db,
    'runbeat': run_celery_beat,
    'runworker': run_celery_worker,
    # 'fetchmacros': fetch_macros, # dont work
    # 'fetchipv6': fetch_ipv6, # dont work
}


def help():
    print('[+] ------------------------------')
    print('[+] ----- Available commands -----')
    print('[+] ------------------------------')
    for (cmd, _) in iteritems(COMMANDS):
        print('[+]    python {} {}'.format(sys.argv[0], cmd))
    print('[+] ------------------------------')
    return


def main():
    global COMMANDS

    if len(sys.argv) != 2:
        help()
        return

    for (cmd, func) in iteritems(COMMANDS):
        if sys.argv[1] == cmd:
            func()
            return
    
    help()
    return


if __name__ == '__main__':
    main()
