package main

import (
	"fmt"
	"math/rand"
	"time"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/security/debby/targets/internal/app"
	"a.yandex-team.ru/security/debby/targets/internal/config"
)

func main() {
	cfg, err := config.NewConfig()
	if err != nil {
		panic(err)
	}

	logger, err := zap.New(zap.ConsoleConfig(log.InfoLevel))
	if err != nil {
		panic(fmt.Sprintf("failed to create logger: %s", err))
	}

	rand.Seed(time.Now().UnixNano())

	app, err := app.NewApp(logger, cfg)
	if err != nil {
		panic(fmt.Sprintf("failed to create app: %s", err))
	}

	app.Initialize()
	app.Start()
}
