package app

import (
	"net/http"
	"strconv"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/debby/targets/internal/models"
	"a.yandex-team.ru/security/debby/targets/internal/utils"
)

func (app App) macrosEndpoint(c echo.Context) error {
	// User ID from path `users/:id`
	id := c.Param("id")
	result := []models.Target{}
	switch {
	case utils.IsMacroAcceptable(id, []string{"_DEBBY_NETMAP_IPV6_", "#DEBBY_NETMAP_IPV6#"}):
		allTargets := app.netmapCache.GetTargets()
		for _, target := range allTargets {
			if utils.IsIPv6(target.IP) {
				result = append(result, target)
			}
		}

	case utils.IsMacroAcceptable(id, []string{"_DEBBY_NETMAP_IPV4_", "__DEBBY_NETMAP_IPV4__"}):
		allTargets := app.netmapCache.GetTargets()
		for _, target := range allTargets {
			if !utils.IsIPv6(target.IP) {
				result = append(result, target)
			}
		}

	case utils.IsMacroAcceptable(id, []string{"_DEBBY_DNSCACHE_IPV6_", "__DEBBY_DNSCACHE_IPV6__"}):
		allTargets := app.cvsCache.GetTargets()
		for _, target := range allTargets {
			if utils.IsIPv6(target.IP) {
				result = append(result, target)
			}
		}

	case utils.IsMacroAcceptable(id, []string{"_DEBBY_DNSCACHE_IPV4_", "__DEBBY_DNSCACHE_IPV4__"}):
		allTargets := app.cvsCache.GetTargets()
		for _, target := range allTargets {
			if !utils.IsIPv6(target.IP) {
				result = append(result, target)
			}
		}

	case utils.IsMacroAcceptable(id, []string{"_DEBBY_YP_IPV6_", "__DEBBY_YP_IPV6__"}):
		result = app.ypCache.GetTargets()

	case utils.IsMacroAcceptable(id, []string{"_DEBBY_NETMAP_", "__DEBBY_NETMAP__"}):
		result = app.netmapCache.GetTargets()

	case utils.IsMacroAcceptable(id, []string{"_DEBBY_L3_VS_", "__DEBBY_L3_VS__"}):
		result = app.cvsCache.GetL3IPv6Targets()

	case utils.IsMacroAcceptable(id, []string{"_DEBBY_L3_VS_IPV6_", "__DEBBY_L3_VS_IPV6__"}):
		result = app.cvsCache.GetL3IPv6Targets()

	case utils.IsMacroAcceptable(id, []string{"_DEBBY_ALL_IPV6_", "__DEBBY_ALL_IPV6__"}):
		result = app.getAllKnownIPv6()

	case app.macrosCache.ExistsMacro(id):
		allTargets, _ := app.macrosCache.GetTargets(id)
		result = utils.RemainOnlyKnownIPV6Targets(app.getAllKnownIPv6(), allTargets)
	}

	offset, _ := strconv.ParseUint(c.QueryParam("offset"), 10, 64)
	limit, _ := strconv.ParseUint(c.QueryParam("limit"), 10, 64)
	noshuffle := c.QueryParam("noshuffle") == "1"

	var uniqTargets []models.Target
	if noshuffle {
		uniqTargets = utils.RemainUniqueTargetsNoShuffle(result, app.getYandexnets6Targets())
	} else {
		uniqTargets = utils.RemainUniqueTargets(result, app.getYandexnets6Targets())
	}

	var resultingTargets []models.Target
	if limit == 0 {
		resultingTargets = uniqTargets
	} else {
		resultingTargets = uniqTargets[offset : offset+limit]
	}

	strResult := utils.DumpsTargets(resultingTargets)

	app.logger.Fmt().Infof("input: %s. offset: %d. limit: %d. noshuffle: %v. results: %d", id, offset, limit, noshuffle, len(resultingTargets))

	return c.String(http.StatusOK, strResult)
}
