package app

import (
	"a.yandex-team.ru/security/debby/targets/internal/models"
	"a.yandex-team.ru/security/debby/targets/internal/utils"
)

func (app App) getAllKnownIPv6() []models.Target {
	result := []models.Target{}

	// netmap
	netmapTargets := app.netmapCache.GetTargets()
	for _, target := range netmapTargets {
		if utils.IsIPv6(target.IP) {
			result = append(result, target)
		}
	}

	// dnscache
	dnsCacheTargets := app.cvsCache.GetTargets()
	for _, target := range dnsCacheTargets {
		if utils.IsIPv6(target.IP) {
			result = append(result, target)
		}
	}

	// yp
	ypTargets := app.ypCache.GetTargets()
	result = append(result, ypTargets...)

	// l3 vs ips
	l3IPv6Targets := app.cvsCache.GetL3IPv6Targets()
	result = append(result, l3IPv6Targets...)

	return result
}

func (app App) getYandexnets6Targets() []models.Target {
	// from cache
	if yandexnets6Targets, ok := app.macrosCache.GetTargets("_YANDEXNETS6_"); ok {
		return yandexnets6Targets
	}

	// from hardcoded nets
	return []models.Target{
		models.Parse("2620:10f:d000::/44"),
		models.Parse("2a02:6b8::/32"),
	}
}
