package config

import (
	"context"
	// "os"

	"github.com/heetch/confita"
	"github.com/heetch/confita/backend"
	"github.com/heetch/confita/backend/env"
	// "github.com/heetch/confita/backend/file"

	"a.yandex-team.ru/library/go/yandex/tvm"
)

type Authentication struct {
	BypassAuthentication bool           `config:"bypass_authentication"`
	AllowedTVMClients    []tvm.ClientID `config:"allowed_tvm_clients"`
	AllowedLogins        []string       `config:"allowed_logins"`
}

type Cvs struct {
	KeyPath  string `config:"cvs_key_path"`
	Username string `config:"cvs_username"`
}

type Config struct {
	Authentication Authentication `config:"authentication"`
	Cvs            Cvs            `config:"cvs"`
	HTTPPort       int            `config:"http_port"`
	L3mgrToken     string         `config:"l3mgr_token"`
}

func NewConfig() (*Config, error) {
	cfg := Config{
		Authentication: Authentication{
			BypassAuthentication: false,
			AllowedTVMClients:    []tvm.ClientID{2002104},
			AllowedLogins:        []string{"procenkoeg", "robot-pika"},
		},
		HTTPPort: 9654,
		Cvs: Cvs{
			KeyPath:  "/tmp/robot-pika_id_rsa",
			Username: "robot-pika",
		},
	}

	// configPath := os.Getenv("CONFIG_PATH")
	backends := []backend.Backend{env.NewBackend()}
	// if configPath != "" {
	// backends = append(
	// []backend.Backend{file.NewBackend(configPath)},
	// backends...,
	// )
	// }

	err := confita.NewLoader(backends...).Load(context.Background(), &cfg)
	if err != nil {
		return nil, err
	} else {
		return &cfg, nil
	}
}
