package models

import (
	"fmt"
	"net"
	"strings"
)

type Target struct {
	IP        net.IP     `json:"ip"`
	FQDN      *string    `json:"fqdn"`
	NET       *net.IPNet `json:"net"`
	ProjectID *string    `json:"project_id"`
}

func (t *Target) Dumps() string {
	switch {
	case len(t.IP) > 0:
		return t.IP.String()
	case t.NET != nil && t.ProjectID != nil:
		return fmt.Sprintf("%s@%s", *t.ProjectID, t.NET.String())
	case t.NET != nil && t.ProjectID == nil:
		return t.NET.String()
	case t.FQDN != nil:
		return *t.FQDN
	default:
		return ""
	}
}

func Parse(s string) Target {
	ip := net.ParseIP(s)
	if ip != nil {
		return Target{IP: ip}
	}

	parts := strings.Split(s, "@")
	var projectID *string
	netStr := s
	if len(parts) == 2 {
		projectID = &parts[0]
		netStr = parts[1]
	}
	_, netPtr, err := net.ParseCIDR(netStr)
	if err == nil {
		return Target{NET: netPtr, ProjectID: projectID}
	}

	return Target{FQDN: &s}
}
