package main

import (
	"context"
	"fmt"
	"log"
	"os"

	"a.yandex-team.ru/library/go/maxprocs"
	"a.yandex-team.ru/security/dnsdb-proxy/internal/cache"
	"a.yandex-team.ru/security/dnsdb-proxy/internal/routes"
)

func newCacheClient(ctx context.Context) (client *cache.Client, err error) {
	authToken := os.Getenv("YDB_TOKEN")
	database := os.Getenv("YDB_DATABASE")
	endpoint := os.Getenv("YDB_ENDPOINT")

	return cache.NewClient(ctx, authToken, database, endpoint)
}

func main() {
	maxprocs.AdjustQloud()

	ctx, cancel := context.WithCancel(context.Background())
	defer cancel()

	cacheClient, err := newCacheClient(ctx)
	if err != nil {
		log.Fatalf("failed to create cache client: %v\n", err)
		return
	}
	defer func() { _ = cacheClient.Reset() }()

	e, err := routes.NewRoutes(cacheClient)
	if err != nil {
		log.Fatalf("failed to create cache client: %v\n", err)
		return
	}

	port := os.Getenv("QLOUD_HTTP_PORT")
	if port == "" {
		port = "3000"
	}

	err = e.Start(fmt.Sprintf(":%s", port))
	if err != nil {
		log.Fatalln(err)
	}
}
