package cache

import (
	"encoding/json"

	"a.yandex-team.ru/security/dnsdb-proxy/internal/unistat"
)

const (
	StatusHotCache = iota
	StatusCache
	StatusNew
	StatusRefresh
	StatusUpstreamFail
)

type Status struct {
	Status int
}

func (c Status) String() string {
	switch c.Status {
	case StatusHotCache:
		return "hot-cache"
	case StatusCache:
		return "cache"
	case StatusNew:
		return "new"
	case StatusRefresh:
		return "refresh"
	case StatusUpstreamFail:
		return "upstream-fail"
	}
	return "unknown"
}

func (c Status) Stat(stat *unistat.Counter) {
	switch c.Status {
	case StatusHotCache:
		stat.AddCacheHit()
	case StatusCache:
		stat.AddCacheHit()
	case StatusNew:
		stat.AddDNSFetch()
		stat.AddDNSNew()
	case StatusRefresh:
		stat.AddDNSFetch()
		stat.AddDNSRefresh()
	case StatusUpstreamFail:
		stat.AddDNSFail()
	}
}

func (c Status) MarshalJSON() ([]byte, error) {
	return json.Marshal(c.String())
}
