package routes

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/core/buildinfo"
	"a.yandex-team.ru/security/dnsdb-proxy/internal/cache"
	"a.yandex-team.ru/security/dnsdb-proxy/internal/unistat"
)

func NewRoutes(cacheClient *cache.Client) (e *echo.Echo, err error) {
	e = echo.New()
	e.Debug = false

	stat := unistat.NewCounter()

	e.GET("/ping", func(c echo.Context) error {
		return c.String(http.StatusOK, "ok")
	})

	e.GET("/version", func(c echo.Context) error {
		return c.String(200, buildinfo.Info.ProgramVersion)
	})

	e.File("/", "static/index.html")

	e.GET("/unistat", func(c echo.Context) error {
		return c.JSON(http.StatusOK, stat.FlushSignals())
	})

	e.GET("/lookup/*any", newLookupHandler(cacheClient, stat))

	return
}
