package upstream

import (
	"fmt"
	"io/ioutil"
	"net/http"

	"a.yandex-team.ru/security/libs/go/yahttp"
)

const (
	upstreamPrefix = "https://dnsdb.viewer.yandex-team.ru"
)

func Fetch(uri string, authToken string) (result []byte, err error) {
	var req *http.Request
	req, err = http.NewRequest("GET", upstreamPrefix+uri, nil)
	if err != nil {
		return
	}

	req.Header.Set("Accept", "application/json")
	req.Header.Set("Authorization", authToken)

	var res *http.Response
	res, err = yahttp.DoRequest(req)
	if err != nil {
		return
	}
	defer yahttp.GracefulClose(res.Body)

	if res.StatusCode != 200 {
		err = fmt.Errorf("not 200 status code: %d", res.StatusCode)
		return
	}

	result, err = ioutil.ReadAll(res.Body)
	return
}
