package cleaner

import (
	"time"

	"go.uber.org/zap"
)

type Option func(*Cleaner)

func WithTTL(ttl time.Duration) Option {
	return func(cleaner *Cleaner) {
		cleaner.ttl = ttl
	}
}

func WithLogger(l *zap.Logger) Option {
	return func(cleaner *Cleaner) {
		cleaner.log = l
	}
}
