package stampdb

import (
	"time"

	"go.uber.org/zap"
)

type WriterOption func(db *Writer)

func WithWriterFlushPeriod(d time.Duration) WriterOption {
	return func(db *Writer) {
		db.flushPeriod = d
	}
}

func WithWriterTTL(ttl time.Duration) WriterOption {
	return func(db *Writer) {
		db.deletesTTL = ttl
	}
}

func WithWriterLogger(l *zap.Logger) WriterOption {
	return func(db *Writer) {
		db.log = l
	}
}

func WithWriterMaxAssoc(d time.Duration) WriterOption {
	return func(db *Writer) {
		db.maxAssoc = d
	}
}
