package synchronizer

import (
	"time"

	"go.uber.org/zap"
)

const DefaultFlushPeriod = time.Minute

var TrustedServers = []string{
	"violet.yndx.net",
	"lead.yndx.net",
}

type Config struct {
	trustedServers []string
	flushPeriod    time.Duration
	outDir         string
	log            *zap.Logger
}

func NewConfig() *Config {
	return &Config{
		// https://bb.yandex-team.ru/projects/NOC/repos/fw-filter/browse/firsthop-receiver.c#95-98
		trustedServers: TrustedServers,
		flushPeriod:    DefaultFlushPeriod,
		outDir:         ".",
		log:            zap.NewNop(),
	}
}

func (c *Config) WithTrustedServers(servers ...string) *Config {
	c.trustedServers = servers
	return c
}

func (c *Config) WithFlushPeriod(d time.Duration) *Config {
	c.flushPeriod = d
	return c
}

func (c *Config) WithOutDir(outDir string) *Config {
	c.outDir = outDir
	return c
}

func (c *Config) WithLogger(l *zap.Logger) *Config {
	c.log = l
	return c
}

func (c *Config) Build() *Config {
	return c
}
