#include "config.h"

#include <contrib/libs/yaml-cpp/include/yaml-cpp/yaml.h>
#include <library/cpp/yaml/as/tstring.h>
#include <util/system/fs.h>

namespace NFuuuTPM {
    namespace {
        const char *kDefaultBackend = "/usr/lib64/pkcs11/libtpm2_pkcs11.so.0.0.0";
    }

    TConfig TConfig::FromFile(const TString &filepath) {
        if (!NFs::Exists(filepath)) {
            ythrow yexception() << "bad config: file " << filepath << " not found";
        }

        YAML::Node node = YAML::LoadFile(filepath);

        TConfig cfg = {
            .Debug = node["debug"].IsDefined() && node["debug"].as<bool>(),
            .BackendPath = kDefaultBackend,
            .SavedTokens = {},
        };

        if (node["backend"].IsDefined()) {
            cfg.BackendPath = node["backend"].as<TString>();
        }

        for (const auto &token: node["saved_tokens"]) {
            cfg.SavedTokens.push_back(TSavedToken{
                .Label = token["label"].as<TString>(),
                .UserPin = token["userpin"].as<TString>(),
            });
        }

        return std::move(cfg);
    }
}