#include "fuuu-tpm.h"

#include <util/string/strip.h>


namespace NFuuuTPM {

    TFuuuTPM::TFuuuTPM(const TConfig& cfg) : cfg(cfg), lib(cfg.BackendPath) {
        Initialize = (CK_C_Initialize) lib.Sym("C_Initialize");
        Finalize = (CK_C_Finalize) lib.Sym("C_Finalize");
        GetInfo = (CK_C_GetInfo) lib.Sym("C_GetInfo");
        GetSlotList = (CK_C_GetSlotList) lib.Sym("C_GetSlotList");
        GetSlotInfo = (CK_C_GetSlotInfo) lib.Sym("C_GetSlotInfo");
        GetTokenInfo = (CK_C_GetTokenInfo) lib.Sym("C_GetTokenInfo");
        GetMechanismList = (CK_C_GetMechanismList) lib.Sym("C_GetMechanismList");
        GetMechanismInfo = (CK_C_GetMechanismInfo) lib.Sym("C_GetMechanismInfo");
        OpenSession = (CK_C_OpenSession) lib.Sym("C_OpenSession");
        CloseSession = (CK_C_CloseSession) lib.Sym("C_CloseSession");
        CloseAllSessions = (CK_C_CloseAllSessions) lib.Sym("C_CloseAllSessions");
        GetSessionInfo = (CK_C_GetSessionInfo) lib.Sym("C_GetSessionInfo");
        Login = (CK_C_Login) lib.Sym("C_Login");
        Logout = (CK_C_Logout) lib.Sym("C_Logout");
        GetAttributeValue = (CK_C_GetAttributeValue) lib.Sym("C_GetAttributeValue");
        SetAttributeValue = (CK_C_SetAttributeValue) lib.Sym("C_SetAttributeValue");
        FindObjectsInit = (CK_C_FindObjectsInit) lib.Sym("C_FindObjectsInit");
        FindObjects = (CK_C_FindObjects) lib.Sym("C_FindObjects");
        FindObjectsFinal = (CK_C_FindObjectsFinal) lib.Sym("C_FindObjectsFinal");
        SignInit = (CK_C_SignInit) lib.Sym("C_SignInit");
        Sign = (CK_C_Sign) lib.Sym("C_Sign");
        SignUpdate = (CK_C_SignUpdate) lib.Sym("C_SignUpdate");
        SignFinal = (CK_C_SignFinal) lib.Sym("C_SignFinal");
    }

    bool TFuuuTPM::MapSavedToken(CK_SLOT_ID slotID, CK_TOKEN_INFO_PTR pInfo) {
        if (pInfo == nullptr) {
            return false;
        }

        auto label = Strip(TString{(char *) pInfo->label, sizeof(((CK_TOKEN_INFO *) nullptr)->label)});
        for (size_t i = 0; i < cfg.SavedTokens.size(); ++i) {
            if (label == cfg.SavedTokens[i].Label) {
                slotToSavedTokens[slotID] = i;
                pInfo->flags &= CKF_PROTECTED_AUTHENTICATION_PATH;
                return true;
            }
        }

        return false;
    }

    TString TFuuuTPM::UserPin(CK_SLOT_ID slotID) {
        if (!slotToSavedTokens.contains(slotID)) {
            return TString{};
        }

        return cfg.SavedTokens[slotToSavedTokens[slotID]].UserPin;
    }
}