package main

import (
	"context"
	"net/http"
	"os"
	"os/signal"
	"syscall"

	"github.com/go-chi/chi/v5"
	"github.com/spf13/pflag"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/security/gideon/fake-iss/issres"
	"a.yandex-team.ru/security/libs/go/chim"
)

func main() {
	var addr string
	pflag.StringVar(&addr, "addr", "127.0.0.1:25536", "addr to listen")
	pflag.Parse()

	logger := zap.Must(zap.ConsoleConfig(log.DebugLevel))

	r := chi.NewRouter()
	r.Use(chim.LogRequest(logger))

	r.Get("/instances", func(w http.ResponseWriter, _ *http.Request) {
		_, _ = w.Write(issres.Instances)
	})

	r.Get("/pods/info", func(w http.ResponseWriter, _ *http.Request) {
		_, _ = w.Write(issres.Pods)
	})

	srv := http.Server{
		Addr:    addr,
		Handler: r,
	}

	stopChan := make(chan os.Signal, 1)
	signal.Notify(stopChan, syscall.SIGINT, syscall.SIGTERM)

	errChan := make(chan error, 1)
	go func() {
		logger.Infof("starting fake ISS application as %s", addr)

		if err := srv.ListenAndServe(); err != nil {
			errChan <- err
		}
	}()

	select {
	case <-stopChan:
		logger.Info("shutting down")
		if err := srv.Shutdown(context.TODO()); err != nil {
			logger.Fatal("failed to shutdown app instance", log.Error(err))
		}
	case err := <-errChan:
		logger.Fatal("shit happens", log.Error(err))
	}
}
