#ifndef __GIDEON_H
#define __GIDEON_H

#define TASK_COMM_LEN 16

typedef unsigned char __u8;
typedef unsigned short __u16;
typedef unsigned int __u32;
typedef unsigned long long __u64;

enum event_kind
{
    EVENT_KIND_UNKNOWN = 0,
    EVENT_KIND_MK_CGROUP = 1,
    EVENT_KIND_RM_CGROUP = 2,
    EVENT_KIND_SYSCALL = 3,
    EVENT_KIND_PROC_EXEC = 4,
    EVENT_KIND_NEW_SESSION = 5,
};

// Hint: https://filippo.io/linux-syscall-table/
enum syscall_kind
{
    SYSCALL_CONNECT   = 42,
    SYSCALL_PTRACE    = 101,
    SYSCALL_OPEN_AT   = 257,
    SYSCALL_EXECVE_AT = 322,
};

struct event_header_t
{
    __u8 kind;
    __u64 ts;
};

struct proc_info_t
{
    __u64 cgid;
    __u32 uid;
    __u32 sessid;
    __u32 pid;
    __u32 ppid;
    char comm[TASK_COMM_LEN];
    char parent_comm[TASK_COMM_LEN];
};

struct bpf_settings_t
{
	__u64 root_cgroup_id;
} __attribute__((packed));

#endif
