#ifndef __LINUX_DEFS_H
#define __LINUX_DEFS_H

#define SYSCALL_MAX_N 323

#define SECCOMP_MODE_DISABLED	0 /* seccomp is not in use. */
#define SECCOMP_MODE_STRICT	1 /* uses hard-coded filter. */
#define SECCOMP_MODE_FILTER	2 /* uses user-supplied filter. */

#define AT_FDCWD 0xfffafdcd
#define O_ACCMODE	00000003
#define O_RDONLY	00000000
#define O_WRONLY	00000001
#define O_RDWR		00000002

#define	EFAULT		14		/* Bad address */
#define	EINVAL		22		/* Invalid argument */
#define	EINPROGRESS	36		/* Operation now in progress */

#define SYS_PTRACE_TRACEME		   0
#define SYS_PTRACE_PEEKTEXT		   1
#define SYS_PTRACE_PEEKDATA		   2
#define SYS_PTRACE_PEEKUSR		   3
#define SYS_PTRACE_POKETEXT		   4
#define SYS_PTRACE_POKEDATA		   5
#define SYS_PTRACE_POKEUSR		   6
#define SYS_PTRACE_CONT		       7
#define SYS_PTRACE_KILL		       8
#define SYS_PTRACE_SINGLESTEP	   9
#define SYS_PTRACE_ATTACH		  16
#define SYS_PTRACE_DETACH		  17
#define SYS_PTRACE_SYSCALL		  24

#define AF_UNSPEC      0
#define AF_UNIX        1          /* Unix domain sockets */
#define AF_LOCAL       1          /* POSIX name for AF_UNIX */
#define AF_INET        2          /* Internet IP Protocol */
#define AF_AX25        3          /* Amateur Radio AX.25 */
#define AF_IPX         4          /* Novell IPX */
#define AF_APPLETALK   5          /* AppleTalk DDP */
#define AF_NETROM      6          /* Amateur Radio NET/ROM */
#define AF_BRIDGE      7          /* Multiprotocol bridge */
#define AF_ATMPVC      8          /* ATM PVCs */
#define AF_X25         9          /* Reserved for X.25 project */
#define AF_INET6       10         /* IP version 6 */
#define AF_ROSE        11         /* Amateur Radio X.25 PLP */
#define AF_DECnet      12         /* Reserved for DECnet project */
#define AF_NETBEUI     13         /* Reserved for 802.2LLC project */
#define AF_SECURITY    14         /* Security callback pseudo AF */
#define AF_KEY         15         /* PF_KEY key management API */
#define AF_NETLINK     16
#define AF_ROUTE       AF_NETLINK /* Alias to emulate 4.4BSD */
#define AF_PACKET      17         /* Packet family */
#define AF_ASH         18         /* Ash */
#define AF_ECONET      19         /* Acorn Econet */
#define AF_ATMSVC      20         /* ATM SVCs */
#define AF_RDS         21         /* RDS sockets */
#define AF_SNA         22         /* Linux SNA Project (nutters!) */
#define AF_IRDA        23         /* IRDA sockets */
#define AF_PPPOX       24         /* PPPoX sockets */
#define AF_WANPIPE     25         /* Wanpipe API Sockets */
#define AF_LLC         26         /* Linux LLC */
#define AF_IB          27         /* Native InfiniBand address */
#define AF_MPLS        28         /* MPLS */
#define AF_CAN         29         /* Controller Area Network */
#define AF_TIPC        30         /* TIPC sockets */
#define AF_BLUETOOTH   31         /* Bluetooth sockets */
#define AF_IUCV        32         /* IUCV sockets */
#define AF_RXRPC       33         /* RxRPC sockets */
#define AF_ISDN        34         /* mISDN sockets */
#define AF_PHONET      35         /* Phonet sockets */
#define AF_IEEE802154  36         /* IEEE802154 sockets */
#define AF_CAIF        37         /* CAIF sockets */
#define AF_ALG         38         /* Algorithm sockets */
#define AF_NFC         39         /* NFC sockets */
#define AF_VSOCK       40         /* vSockets */
#define AF_KCM         41         /* Kernel Connection Multiplexor */
#define AF_QIPCRTR     42         /* Qualcomm IPC Router */
#define AF_SMC         43         /* smc sockets: reserve number for PF_SMC protocol family that reuses AF_INET address family */


#define inet_daddr     sk.__sk_common.skc_daddr
#define inet_rcv_saddr sk.__sk_common.skc_rcv_saddr
#define inet_dport     sk.__sk_common.skc_dport
#define inet_num       sk.__sk_common.skc_num

#define sk_node             __sk_common.skc_node
#define sk_nulls_node       __sk_common.skc_nulls_node
#define sk_refcnt           __sk_common.skc_refcnt
#define sk_tx_queue_mapping __sk_common.skc_tx_queue_mapping

#define sk_dontcopy_begin __sk_common.skc_dontcopy_begin
#define sk_dontcopy_end   __sk_common.skc_dontcopy_end
#define sk_hash           __sk_common.skc_hash
#define sk_portpair       __sk_common.skc_portpair
#define sk_num            __sk_common.skc_num
#define sk_dport          __sk_common.skc_dport
#define sk_addrpair       __sk_common.skc_addrpair
#define sk_daddr          __sk_common.skc_daddr
#define sk_rcv_saddr      __sk_common.skc_rcv_saddr
#define sk_family         __sk_common.skc_family
#define sk_state          __sk_common.skc_state
#define sk_reuse          __sk_common.skc_reuse
#define sk_reuseport      __sk_common.skc_reuseport
#define sk_ipv6only       __sk_common.skc_ipv6only
#define sk_net_refcnt     __sk_common.skc_net_refcnt
#define sk_bound_dev_if   __sk_common.skc_bound_dev_if
#define sk_bind_node      __sk_common.skc_bind_node
#define sk_prot           __sk_common.skc_prot
#define sk_net            __sk_common.skc_net
#define sk_v6_daddr       __sk_common.skc_v6_daddr
#define sk_v6_rcv_saddr   __sk_common.skc_v6_rcv_saddr
#define sk_cookie         __sk_common.skc_cookie
#define sk_incoming_cpu   __sk_common.skc_incoming_cpu
#define sk_flags          __sk_common.skc_flags
#define sk_rxhash         __sk_common.skc_rxhash

enum {
        BPF_F_CURRENT_CPU = 4294967295,
};

#endif /* __LINUX_DEFS_H */
