#ifndef __SETTINGS_H
#define __SETTINGS_H

#include "../prog/gideon.h"
#include "bpf_helpers.h"

struct bpf_map_def settings_map SEC("maps") = {
	.type = BPF_MAP_TYPE_ARRAY,
	.key_size = sizeof(u32),
	.value_size = sizeof(struct bpf_settings_t),
	.max_entries = 1,
};

static __always_inline struct bpf_settings_t *get_bpf_settings(void) {
	u32 id = 0;
	return bpf_map_lookup_elem(&settings_map, &id);
}

#endif
