#ifndef __BPF_HELPERS_H
#define __BPF_HELPERS_H

#include <linux/bpf.h> // Y_IGNORE

#define BUF_SIZE_MAP_NS 256

#define _section(NAME) __attribute__((section(NAME), used))\

#define BPF_LOAD(P)                          \
  ({                                         \
    typeof(P) _val;                          \
    __builtin_memset(&_val, 0, sizeof(_val));\
    bpf_probe_read(&_val, sizeof(_val), &P); \
    _val;                                    \
  })

#define PT_REGS_ARG_0(x) ((x)->di)
#define PT_REGS_ARG_1(x) ((x)->si)
#define PT_REGS_ARG_2(x) ((x)->dx)
#define PT_REGS_ARG_3(x) ((x)->cx)
#define PT_REGS_ARG_4(x) ((x)->r8)
#define PT_REGS_RET(x) ((x)->sp)
#define PT_REGS_FP(x) ((x)->bp)
#define PT_REGS_RC(x) ((x)->ax)
#define PT_REGS_SP(x) ((x)->sp)
#define PT_REGS_IP(x) ((x)->ip)

#define SYSCALL_ARG_0 BPF_LOAD(regs->di)
#define SYSCALL_ARG_1 BPF_LOAD(regs->si)
#define SYSCALL_ARG_2 BPF_LOAD(regs->dx)
#define SYSCALL_ARG_3 BPF_LOAD(regs->r10)
#define SYSCALL_ARG_4 BPF_LOAD(regs->r8)
#define SYSCALL_ARG_5 BPF_LOAD(regs->r9)

#define SYSCALL_MAX_N 323

/* From tools/lib/bpf/libbpf.h */
struct bpf_map_def {
	unsigned int type;
	unsigned int key_size;
	unsigned int value_size;
	unsigned int max_entries;
	unsigned int map_flags;
};

// helper functions called from eBPF programs written in C
// definitions of bpf helper functions we need, as found in
// https://github.com/iovisor/bcc/blob/2fa54c0bd388898fdda58f30dcfe5a68d6715efc/src/cc/export/helpers.h
static void* (*bpf_map_lookup_elem)(void* map, void* key) = (void*)BPF_FUNC_map_lookup_elem;
static int (*bpf_map_update_elem)(void* map, void* key, void* value, u64 flags) = (void*)BPF_FUNC_map_update_elem;
static int (*bpf_map_delete_elem)(void* map, void* key) = (void*)BPF_FUNC_map_delete_elem;
static int (*bpf_probe_read)(void* dst, int size, void* unsafe_ptr) = (void*)BPF_FUNC_probe_read;
static int (*bpf_trace_printk)(const char* fmt, int fmt_size, ...) = (void*)BPF_FUNC_trace_printk;
static int (*bpf_perf_event_output)(void* ctx, void* map, int index, void* data, int size) = (void*)BPF_FUNC_perf_event_output;
static u64 (*bpf_get_current_task)(void) = (void*)BPF_FUNC_get_current_task;
static u64 (*bpf_get_current_pid_tgid)(void) = (void*)BPF_FUNC_get_current_pid_tgid;
static unsigned long long (*bpf_get_current_uid_gid)(void) = (void*) BPF_FUNC_get_current_uid_gid;
static unsigned long long (*bpf_ktime_get_ns)(void) = (void*)BPF_FUNC_ktime_get_ns;
static u64 (*bpf_get_smp_processor_id)(void) = (void*)BPF_FUNC_get_smp_processor_id;
static void (*bpf_tail_call)(void *ctx, void *map, int index) = (void *)BPF_FUNC_tail_call;
static int (*bpf_probe_read_str)(void* dst, u64 size, const void* unsafe_ptr) = (void*)BPF_FUNC_probe_read_str;

#ifdef BPF_DEBUG
#define bpf_printk(fmt, ...)					       \
	do {							                   \
		char s[] = fmt;				 	               \
		bpf_trace_printk(s, sizeof(s), ##__VA_ARGS__); \
	} while (0)
#else
#define bpf_printk(fmt, ...)
#endif

#endif
