package main

import (
	"context"
	"flag"
	"fmt"
	"log"

	"a.yandex-team.ru/security/gideon/gideon/internal/podresolver"
)

func main() {
	flag.Parse()

	r, err := podresolver.NewResolver()
	if err != nil {
		log.Fatalf("can't create pod resolver: %v\n", err)
	}

	log.Println("Sync...")
	if !r.Sync(context.Background()) {
		log.Println("ship happens")
		return
	}

	log.Println("Synced")
	for _, c := range flag.Args() {
		p, err := r.CachedSlot(c)
		if err != nil {
			log.Printf("can't resolve container %s: %v\n", c, err)
		}

		fmt.Printf("Pod %s info:\n%+v\n\n", c, p)
	}
}
