package e2e

import (
	"context"
	"testing"
	"time"

	"github.com/stretchr/testify/require"
	"go.uber.org/zap"
	"go.uber.org/zap/zaptest"

	xzap "a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/security/gideon/gideon/internal/app"
	"a.yandex-team.ru/security/gideon/gideon/internal/config"
)

type GideonApp struct {
	app  *app.App
	done chan struct{}
}

func (g *GideonApp) Close() {
	// TODO(buglloc): do smth better
	time.Sleep(3 * time.Second)

	_ = g.app.Shutdown(context.Background())
	<-g.done
}

func NewGideonApp(t *testing.T, cfg config.Config) *GideonApp {
	l := &xzap.Logger{
		L: zaptest.NewLogger(t).WithOptions(zap.Development()),
	}

	a, err := app.NewApp(&cfg, l)
	require.NoError(t, err)

	g := &GideonApp{
		app:  a,
		done: make(chan struct{}),
	}

	wait := make(chan struct{})
	go func() {
		err = g.app.Start(func() {
			close(wait)
		})

		close(g.done)
		select {
		case <-wait:
		default:
			close(wait)
		}
	}()

	<-wait
	require.NoError(t, err, "failed to start gideon")
	return g
}
