package bytebuffer

const (
	minSize = 512     // Minimum chunk size that is reused, reusing chunks too small will result in overhead.
	maxSize = 8 << 10 // Maximum chunk size that will be allocated.
)

var (
	bytesChunkSizeClasses = []int{
		1 << 10,
		2 << 10,
		4 << 10,
		8 << 10,
	}

	lastPool = len(bytesChunkSizeClasses) - 1

	//TODO(buglloc): auto-calibrate
	bytesChunkPools = [...]bytesPool{
		newBufferPool(1<<10, 32<<5),
		newBufferPool(2<<10, 32<<4),
		newBufferPool(4<<10, 32<<3),
		newBufferPool(8<<10, 32<<2),
	}
)

func GetBytesBufferChunk(size int) []byte {
	if size < minSize || size > maxSize {
		return make([]byte, size)
	}

	i := 0
	for ; i < lastPool; i++ {
		if size <= bytesChunkSizeClasses[i] {
			break
		}
	}

	return bytesChunkPools[i].Get()[:size]
}

func PutBytesBufferChunk(p []byte) {
	size := cap(p)
	if size < minSize || size > maxSize {
		return
	}

	for i, n := range bytesChunkSizeClasses {
		if size == n {
			bytesChunkPools[i].Put(p)
			return
		}
	}
}
