package bytebuffer

type bytesPool struct {
	size int
	c    chan []byte
}

func newBufferPool(size, maxItems int) bytesPool {
	return bytesPool{
		size: size,
		c:    make(chan []byte, maxItems),
	}
}

func (bp *bytesPool) Get() (out []byte) {
	select {
	case out = <-bp.c:
	default:
		out = make([]byte, bp.size)
	}
	return
}

func (bp *bytesPool) Put(b []byte) {
	if cap(b) != bp.size {
		return
	}

	select {
	case bp.c <- b:
	default:
		// bye-bye, channel is full
	}
}
