package byteorder

import (
	"encoding/binary"
	"unsafe"
)

var Big = binary.BigEndian

var Little = binary.LittleEndian

var Host = func() binary.ByteOrder {
	var i int32 = 0x01020304
	u := unsafe.Pointer(&i)
	pb := (*byte)(u)
	b := *pb
	if b == 0x04 {
		return Little
	}

	return Big
}()
