package cgroup

import (
	"fmt"

	"golang.org/x/sys/unix"

	"a.yandex-team.ru/security/gideon/gideon/internal/byteorder"
)

func GetCgroupID(path string) (uint64, error) {
	handle, _, err := unix.NameToHandleAt(unix.AT_FDCWD, path, 0)
	if err != nil {
		return 0, err
	}

	cgrpID := byteorder.Host.Uint64(handle.Bytes())
	if cgrpID == 0 {
		return 0, fmt.Errorf("no cgroup id for path: %s", path)
	}

	return cgrpID, err
}
