//go:build cgo
// +build cgo

package internal

//#include "cgroup_test.h"
import "C"
import (
	"fmt"
	"unsafe"
)

func GetCgroupIDCGO(path string) (uint64, error) {
	cpath := C.CString(path)
	ret := uint64(C.get_cgroupid(cpath))
	C.free(unsafe.Pointer(cpath))
	if ret == 0 {
		return 0, fmt.Errorf("no cgrp id for path: %s", path)
	}

	return ret, nil
}
