package collector

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log/nop"
	"a.yandex-team.ru/security/gideon/gideon/internal/collector/httpcollector"
	"a.yandex-team.ru/security/gideon/gideon/internal/collector/lbcollector"
	"a.yandex-team.ru/security/gideon/gideon/internal/collector/nopcollector"
	"a.yandex-team.ru/security/gideon/gideon/internal/collector/stdcollector"
	"a.yandex-team.ru/security/gideon/gideon/internal/config"
	"a.yandex-team.ru/security/gideon/gideon/internal/sensors"
)

func NewByConfig(cfg *config.Config, opts ...Option) (Collector, error) {
	o := options{
		logger:  &nop.Logger{},
		metrics: &sensors.NopSensor{},
	}

	for _, opt := range opts {
		opt(&o)
	}

	switch cfg.Tracer.Collector {
	case stdcollector.Name:
		return stdcollector.NewCollector(o.logger), nil
	case httpcollector.Name:
		return httpcollector.NewCollector(
			cfg.HTTPCollector,
			httpcollector.WithLogger(o.logger),
			httpcollector.WithMetrics(o.metrics),
		), nil
	case lbcollector.Name:
		return lbcollector.NewCollector(
			cfg.LBCollector,
			lbcollector.WithLogger(o.logger),
			lbcollector.WithMetrics(o.metrics),
			lbcollector.WithSecrets(cfg.Secrets),
		)
	case nopcollector.Name:
		return nopcollector.NewCollector(o.logger), nil
	default:
		return nil, fmt.Errorf(
			"unknown collector %q, available: %q, %q %q, and %q",
			cfg.Tracer.Collector,
			stdcollector.Name,
			httpcollector.Name,
			lbcollector.Name,
			nopcollector.Name,
		)
	}
}
