package httpcollector

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/gideon/gideon/internal/sensors"
)

type Option func(*HTTPCollector)

func WithLogger(l log.Logger) Option {
	return func(c *HTTPCollector) {
		c.log = l
	}
}

func WithMetrics(sensor sensors.Sensor) Option {
	return func(c *HTTPCollector) {
		c.metrics = sensor
	}
}
