package lbcollector

import (
	"fmt"
	"time"

	"gopkg.in/yaml.v2"

	"a.yandex-team.ru/library/go/yandex/tvm"
)

type Config struct {
	AuthKind        AuthKind      `yaml:"auth_kind"`
	OAuthToken      string        `yaml:"oauth_token"`
	TVM             TVMConfig     `yaml:"tvm"`
	Endpoint        string        `yaml:"endpoint"`
	Topic           string        `yaml:"topic"`
	FlushInterval   time.Duration `yaml:"flush_interval"`
	WriteBufferSize int           `yaml:"write_buffer_size"`
	MaxMemoryUsage  int           `yaml:"max_memory_usage"`
	Compression     bool          `yaml:"compression"`
}

type TVMConfig struct {
	Secret string       `yaml:"secret"`
	SelfID tvm.ClientID `yaml:"self_id"`
}

var (
	_ yaml.Marshaler   = (*AuthKind)(nil)
	_ yaml.Unmarshaler = (*AuthKind)(nil)
)

type AuthKind uint16

const (
	AuthKindNone  AuthKind = 0
	AuthKindOAuth AuthKind = 1
	// temporary disabled
	//AuthKindTVM   AuthKind = 2
)

func (pk AuthKind) MarshalYAML() (interface{}, error) {
	return pk.String(), nil
}

func (pk *AuthKind) UnmarshalYAML(unmarshal func(interface{}) error) error {
	var kind string
	if err := unmarshal(&kind); err != nil {
		return err
	}

	switch kind {
	case "none", "":
		*pk = AuthKindNone
	case "oauth":
		*pk = AuthKindOAuth
	//case "tvm":
	//	*pk = AuthKindTVM
	default:
		return fmt.Errorf("unknown auth kind: %s", kind)
	}
	return nil
}

func (pk AuthKind) String() string {
	switch pk {
	case AuthKindNone:
		return "none"
	case AuthKindOAuth:
		return "oauth"
	//case AuthKindTVM:
	//	return "tvm"
	default:
		return "unknown"
	}
}
