package lbcollector

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/gideon/gideon/internal/secrets"
	"a.yandex-team.ru/security/gideon/gideon/internal/sensors"
)

type Option func(*LbCollector)

func WithLogger(l log.Logger) Option {
	return func(c *LbCollector) {
		c.log = l
	}
}

func WithMetrics(sensor sensors.Sensor) Option {
	return func(c *LbCollector) {
		c.metrics = sensor
	}
}

func WithSecrets(secrets secrets.Config) Option {
	return func(c *LbCollector) {
		c.secrets = secrets
	}
}
