package collector

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/gideon/gideon/internal/sensors"
)

type options struct {
	logger  log.Logger
	metrics sensors.Sensor
}

type Option func(*options)

func WithLogger(l log.Logger) Option {
	return func(o *options) {
		o.logger = l
	}
}

func WithMetrics(s sensors.Sensor) Option {
	return func(o *options) {
		o.metrics = s
	}
}
