package stdcollector

import (
	"context"
	"os"

	"github.com/golang/protobuf/jsonpb"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/gideon/gideon/pkg/events"
)

const Name = "StdCollector"

var ln = []byte{0x0a}

type StdCollector struct {
	l log.Logger
	m *jsonpb.Marshaler
}

func NewCollector(l log.Logger) *StdCollector {
	return &StdCollector{
		l: l,
		m: &jsonpb.Marshaler{
			EnumsAsInts:  false,
			EmitDefaults: false,
		},
	}
}

func (c *StdCollector) NewEvent(event *events.Event) {
	if err := c.m.Marshal(os.Stdout, event); err != nil {
		c.l.Error("stdcollector: failed to marshal event",
			log.Sprintf("type", "%T", event),
			log.Error(err))
	}
	_, _ = os.Stdout.Write(ln)
}

func (c *StdCollector) Close(_ context.Context) {

}
