package commands

import (
	"errors"
	"fmt"
	"net"
	"time"

	"github.com/go-resty/resty/v2"
	"github.com/spf13/cobra"
)

var pingCmd = &cobra.Command{
	Use:          "ping",
	SilenceUsage: true,
	Short:        "Ping Gideon",
	RunE: func(cmd *cobra.Command, args []string) error {
		if !cfg.API.Enabled {
			return errors.New("can't ping Gideon w/o API enabled")
		}

		_, p, err := net.SplitHostPort(cfg.API.Addr)
		if err != nil {
			return fmt.Errorf("failed to parse api addr: %w", err)
		}

		rsp, err := resty.New().SetTimeout(500 * time.Millisecond).
			R().Get(fmt.Sprintf("http://localhost:%s/ping", p))
		if err != nil {
			return fmt.Errorf("gideon ping failed: %w", err)
		}

		if !rsp.IsSuccess() {
			return fmt.Errorf("gideon ping failed: unexpected status code: %d", rsp.StatusCode())
		}

		fmt.Println("OK")
		return nil
	},
}

func init() {
	rootCmd.AddCommand(pingCmd)
}
