package commands

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/security/gideon/gideon/internal/config"
)

const (
	defaultCfgPath = "/etc/gideon/default.yaml"
)

var (
	cfg     *config.Config
	cfgPath string
	logger  log.Logger
)

var rootCmd = &cobra.Command{
	Use:          "gideon",
	SilenceUsage: true,
	Short:        "Security probes collector",
	PersistentPreRunE: func(cmd *cobra.Command, args []string) (err error) {
		if cfgPath == "" {
			if _, err := os.Stat(defaultCfgPath); !os.IsNotExist(err) {
				cfgPath = defaultCfgPath
			}
		}

		cfg, err = config.NewConfig(cfgPath)
		if err != nil {
			return fmt.Errorf("failed to parse config: %w", err)
		}

		logger, err = zap.New(cfg.Logger.ZapConfig())
		if err != nil {
			return fmt.Errorf("failed to initialize logger: %w", err)
		}
		return nil
	},
}

func Main() {
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}

func init() {
	flags := rootCmd.PersistentFlags()
	flags.StringVarP(&cfgPath, "config", "c", "",
		fmt.Sprintf("config path (default: %s)", defaultCfgPath),
	)
}
