package commands

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/gideon/gideon/internal/kernel"
)

var supportedCmd = &cobra.Command{
	Use:          "supported",
	SilenceUsage: true,
	Short:        "Check supported kernel",
	PersistentPreRunE: func(cmd *cobra.Command, args []string) error {
		return nil
	},
	RunE: func(cmd *cobra.Command, args []string) error {
		kernelVersion, err := kernel.CurrentVersion()
		if err != nil {
			return err
		}

		err = kernelVersion.CheckPrerequisites()
		if err != nil {
			return err
		}

		fmt.Println("OK")
		return nil
	},
}

func init() {
	rootCmd.AddCommand(supportedCmd)
}
