package ebpfutil

import (
	"fmt"

	"github.com/cilium/ebpf"

	"a.yandex-team.ru/library/go/slices"
	"a.yandex-team.ru/security/gideon/gideon/internal/kernel"
)

func FixUpCollectionSpec(spec *ebpf.CollectionSpec) {
	kernelVersion, err := kernel.RawCurrentVersion()
	if err != nil {
		panic(fmt.Sprintf("failed to get current kernel version: %v", err))
	}

	nCPU, err := PossibleCPUs()
	if err != nil {
		panic(fmt.Sprintf("failed to get possible CPUs: %v", err))
	}

	if nCPU <= 0 || nCPU > 1024 {
		panic(fmt.Sprintf("invalud possible CPUs num: %d", nCPU))
	}

	for _, p := range spec.Programs {
		if p.KernelVersion == 0xFFFFFFFE {
			// use current kernel version
			p.KernelVersion = kernelVersion
		}
	}

	for _, m := range spec.Maps {
		if m.MaxEntries == 0xFFFFFFFE {
			// use current possible CPUs
			m.MaxEntries = uint32(nCPU)
		}
	}
}

func RemoveUnusedProgs(spec *ebpf.CollectionSpec, usedProgs ...string) {
	for name := range spec.Programs {
		if !slices.ContainsString(usedProgs, name) {
			delete(spec.Programs, name)
		}
	}
}
