package podresolver

import (
	"fmt"
)

const (
	ResolverKindUnknown ResolverKind = iota
	ResolverKindISS

	ResolverKindUnknownName = "unknown"
	ResolverKindISSName     = "iss"
)

type ResolverKind uint8

func (k ResolverKind) MarshalYAML() (interface{}, error) {
	return k.String(), nil
}

func (k *ResolverKind) UnmarshalYAML(unmarshal func(interface{}) error) error {
	var kind string
	if err := unmarshal(&kind); err != nil {
		return err
	}

	switch kind {
	case ResolverKindISSName:
		*k = ResolverKindISS
	default:
		return fmt.Errorf("unknown pod resolver kind: %s", kind)
	}
	return nil
}

func (k ResolverKind) String() string {
	switch k {
	case ResolverKindISS:
		return ResolverKindISSName
	default:
		return ResolverKindUnknownName
	}
}
